/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gae.mail;

import com.google.appengine.api.mail.MailService;
import org.apache.camel.Exchange;
import org.apache.camel.component.gae.bind.OutboundBinding;
import org.apache.camel.component.gae.mail.GMailEndpoint;

public class GMailBinding
implements OutboundBinding<GMailEndpoint, MailService.Message, Void> {
    public static final String GMAIL_SENDER = "CamelGmailSender";
    public static final String GMAIL_SUBJECT = "CamelGmailSubject";
    public static final String GMAIL_TO = "CamelGmailTo";
    public static final String GMAIL_CC = "CamelGmailCc";
    public static final String GMAIL_BCC = "CamelGmailBcc";

    @Override
    public MailService.Message writeRequest(GMailEndpoint endpoint, Exchange exchange, MailService.Message request) {
        MailService.Message message = new MailService.Message();
        this.writeFrom(endpoint, exchange, message);
        this.writeTo(endpoint, exchange, message);
        this.writeCc(endpoint, exchange, message);
        this.writeBcc(endpoint, exchange, message);
        this.writeSubject(endpoint, exchange, message);
        this.writeBody(endpoint, exchange, message);
        this.writeAttachments(endpoint, exchange, message);
        return message;
    }

    @Override
    public Exchange readResponse(GMailEndpoint endpoint, Exchange exchange, Void response) {
        throw new UnsupportedOperationException("gmail responses not supported");
    }

    protected void writeFrom(GMailEndpoint endpoint, Exchange exchange, MailService.Message request) {
        String sender = (String)exchange.getIn().getHeader(GMAIL_SENDER);
        if (sender == null) {
            sender = endpoint.getSender();
        }
        request.setSender(sender);
    }

    protected void writeTo(GMailEndpoint endpoint, Exchange exchange, MailService.Message request) {
        String to = (String)exchange.getIn().getHeader(GMAIL_TO);
        if (to == null) {
            to = endpoint.getTo();
        }
        request.setTo(to.split(","));
    }

    protected void writeCc(GMailEndpoint endpoint, Exchange exchange, MailService.Message request) {
        String cc = (String)exchange.getIn().getHeader(GMAIL_CC);
        if (cc == null) {
            cc = endpoint.getCc();
        }
        if (cc != null) {
            request.setCc(cc.split(","));
        }
    }

    protected void writeBcc(GMailEndpoint endpoint, Exchange exchange, MailService.Message request) {
        String bcc = (String)exchange.getIn().getHeader(GMAIL_BCC);
        if (bcc == null) {
            bcc = endpoint.getBcc();
        }
        if (bcc != null) {
            request.setBcc(bcc.split(","));
        }
    }

    protected void writeSubject(GMailEndpoint endpoint, Exchange exchange, MailService.Message request) {
        String subject = (String)exchange.getIn().getHeader(GMAIL_SUBJECT);
        if (subject == null) {
            subject = endpoint.getSubject();
        }
        request.setSubject(subject);
    }

    protected void writeBody(GMailEndpoint endpoint, Exchange exchange, MailService.Message request) {
        request.setTextBody((String)exchange.getIn().getBody(String.class));
    }

    protected void writeAttachments(GMailEndpoint endpoint, Exchange exchange, MailService.Message request) {
    }
}

