/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ganglia;

import info.ganglia.gmetric4j.gmetric.GMetric;
import info.ganglia.gmetric4j.gmetric.GMetricSlope;
import info.ganglia.gmetric4j.gmetric.GMetricType;
import java.io.IOException;
import java.net.URI;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class GangliaConfiguration
implements Cloneable {
    public static final String DEFAULT_DESTINATION = "239.2.11.71";
    public static final int DEFAULT_PORT = 8649;
    public static final GMetric.UDPAddressingMode DEFAULT_MODE = GMetric.UDPAddressingMode.MULTICAST;
    public static final int DEFAULT_TTL = 5;
    public static final boolean DEFAULT_WIRE_FORMAT_31X = true;
    public static final String DEFAULT_GROUP_NAME = "Java";
    public static final String DEFAULT_METRIC_NAME = "metric";
    public static final GMetricType DEFAULT_TYPE = GMetricType.STRING;
    public static final GMetricSlope DEFAULT_SLOPE = GMetricSlope.BOTH;
    public static final String DEFAULT_UNITS = "";
    public static final int DEFAULT_TMAX = 60;
    public static final int DEFAULT_DMAX = 0;
    @UriPath(defaultValue="239.2.11.71")
    private String host = "239.2.11.71";
    @UriPath(defaultValue="8649")
    private int port = 8649;
    @UriParam(defaultValue="MULTICAST")
    private GMetric.UDPAddressingMode mode = DEFAULT_MODE;
    @UriParam(defaultValue="5")
    private int ttl = 5;
    @UriParam(defaultValue="true")
    private boolean wireFormat31x = true;
    @UriParam
    private String spoofHostname;
    @UriParam(defaultValue="java")
    private String groupName = "Java";
    @UriParam
    private String prefix;
    @UriParam(defaultValue="metric")
    private String metricName = "metric";
    @UriParam(defaultValue="STRING")
    private GMetricType type = DEFAULT_TYPE;
    @UriParam(defaultValue="BOTH")
    private GMetricSlope slope = DEFAULT_SLOPE;
    @UriParam
    private String units = "";
    @UriParam(defaultValue="60")
    private int tmax = 60;
    @UriParam(defaultValue="0")
    private int dmax = 0;

    public GangliaConfiguration copy() {
        try {
            GangliaConfiguration copy = (GangliaConfiguration)this.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void configure(URI uri) {
        int port;
        String value = uri.getHost();
        if (value != null) {
            this.setHost(value);
        }
        if ((port = uri.getPort()) > 0) {
            this.setPort(port);
        }
    }

    public GMetric createGMetric() {
        try {
            return new GMetric(this.host, this.port, this.mode, this.ttl, this.wireFormat31x, null, this.spoofHostname);
        }
        catch (IOException ex) {
            throw new RuntimeCamelException("Failed to initialize Ganglia", (Throwable)ex);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public GMetric.UDPAddressingMode getMode() {
        return this.mode;
    }

    public void setMode(GMetric.UDPAddressingMode mode) {
        this.mode = mode;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public boolean getWireFormat31x() {
        return this.wireFormat31x;
    }

    public void setWireFormat31x(boolean wireFormat31x) {
        this.wireFormat31x = wireFormat31x;
    }

    public String getSpoofHostname() {
        return this.spoofHostname;
    }

    public void setSpoofHostname(String spoofHostname) {
        this.spoofHostname = spoofHostname;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public GMetricType getType() {
        return this.type;
    }

    public void setType(GMetricType type) {
        this.type = type;
    }

    public GMetricSlope getSlope() {
        return this.slope;
    }

    public void setSlope(GMetricSlope slope) {
        this.slope = slope;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public boolean isWireFormat31x() {
        return this.wireFormat31x;
    }

    public int getTmax() {
        return this.tmax;
    }

    public void setTmax(int tmax) {
        this.tmax = tmax;
    }

    public int getDmax() {
        return this.dmax;
    }

    public void setDmax(int dmax) {
        this.dmax = dmax;
    }

    public String toString() {
        return "GangliaConfiguration[host=" + this.host + ":" + this.port + ", mode=" + this.mode + ", ttl=" + this.ttl + ", wireFormat31x=" + this.wireFormat31x + ", spoofHostname=" + this.spoofHostname + ", groupName=" + this.groupName + ", prefix=" + this.prefix + ", metricName=" + this.metricName + ", type=" + this.type + ", slope=" + this.slope + ", units=" + this.units + ", tmax=" + this.tmax + ", dmax=" + this.dmax + "]";
    }
}

