/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.IOHelper;

public class GsonDataFormat
implements DataFormat {
    private final Gson gson;
    private Class<?> unmarshalType;

    public GsonDataFormat() {
        this(Map.class);
    }

    public GsonDataFormat(Class<?> unmarshalType) {
        this(new Gson(), unmarshalType);
    }

    public GsonDataFormat(Class<?> unmarshalType, ExclusionStrategy ... exclusionStrategies) {
        this(GsonDataFormat.createGsonWithExclusionStrategy(exclusionStrategies), unmarshalType);
    }

    public GsonDataFormat(Gson gson, Class<?> unmarshalType) {
        this.gson = gson;
        this.unmarshalType = unmarshalType;
    }

    private static Gson createGsonWithExclusionStrategy(ExclusionStrategy ... exclusionStrategies) {
        return exclusionStrategies != null ? new GsonBuilder().setExclusionStrategies(exclusionStrategies).create() : new Gson();
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        BufferedWriter writer = IOHelper.buffered((Writer)new OutputStreamWriter(stream));
        this.gson.toJson(graph, (Appendable)writer);
        writer.close();
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        BufferedReader reader = IOHelper.buffered((Reader)new InputStreamReader(stream));
        Object result = this.gson.fromJson((Reader)reader, this.unmarshalType);
        reader.close();
        return result;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public Gson getGson() {
        return this.gson;
    }
}

