/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.guice;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.guice.impl.GuiceInjector;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.Registry;
import org.guiceyfruit.Injectors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceCamelContext
extends DefaultCamelContext {
    private final Injector injector;

    @Inject
    public GuiceCamelContext(Injector injector) {
        this.injector = injector;
    }

    @PostConstruct
    public void start() throws Exception {
        super.start();
    }

    @PreDestroy
    public void stop() throws Exception {
        super.stop();
    }

    @Inject
    public void setRouteBuilders(Set<RoutesBuilder> routeBuilders) throws Exception {
        for (RoutesBuilder builder : routeBuilders) {
            this.addRoutes(builder);
        }
    }

    @Inject(optional=true)
    public void setRoutes(List<Route> routes) {
        super.setRoutes(routes);
    }

    @Inject(optional=true)
    public void setRegistry(Registry registry) {
        super.setRegistry(registry);
    }

    @Inject(optional=true)
    public void setJndiContext(Context jndiContext) {
        super.setJndiContext(jndiContext);
    }

    @Inject(optional=true)
    public void setInjector(org.apache.camel.spi.Injector injector) {
        super.setInjector(injector);
    }

    @Inject(optional=true)
    public void setComponentResolver(ComponentResolver componentResolver) {
        super.setComponentResolver(componentResolver);
    }

    @Inject(optional=true)
    public void setAutoCreateComponents(boolean autoCreateComponents) {
        super.setAutoCreateComponents(autoCreateComponents);
    }

    @Inject(optional=true)
    public void setErrorHandlerBuilder(ErrorHandlerBuilder errorHandlerBuilder) {
        super.setErrorHandlerBuilder(errorHandlerBuilder);
    }

    @Inject(optional=true)
    public void setInterceptStrategies(List<InterceptStrategy> interceptStrategies) {
        super.setInterceptStrategies(interceptStrategies);
    }

    @Inject(optional=true)
    public void setLanguageResolver(LanguageResolver languageResolver) {
        super.setLanguageResolver(languageResolver);
    }

    @Inject(optional=true)
    public void setLifecycleStrategies(List<LifecycleStrategy> lifecycleStrategies) {
        super.setLifecycleStrategies(lifecycleStrategies);
    }

    @Inject(optional=true)
    public void setTypeConverter(TypeConverter typeConverter) {
        super.setTypeConverter(typeConverter);
    }

    protected org.apache.camel.spi.Injector createInjector() {
        return new GuiceInjector(this.injector);
    }

    protected Registry createRegistry() {
        Context context = this.createContext();
        return new JndiRegistry(context);
    }

    protected Context createContext() {
        Set bindings = Injectors.getBindingsOf((Injector)this.injector, Context.class);
        try {
            if (bindings.isEmpty()) {
                return new InitialContext();
            }
            return (Context)this.injector.getInstance(Context.class);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

