/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hawtdb;

import org.apache.camel.Service;
import org.apache.camel.component.hawtdb.Work;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.codec.BufferCodec;
import org.fusesource.hawtbuf.codec.Codec;
import org.fusesource.hawtbuf.codec.IntegerCodec;
import org.fusesource.hawtbuf.codec.StringCodec;
import org.fusesource.hawtdb.api.BTreeIndexFactory;
import org.fusesource.hawtdb.api.OptimisticUpdateException;
import org.fusesource.hawtdb.api.Paged;
import org.fusesource.hawtdb.api.SortedIndex;
import org.fusesource.hawtdb.api.Transaction;
import org.fusesource.hawtdb.api.TxPageFile;
import org.fusesource.hawtdb.api.TxPageFileFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HawtDBFile
extends TxPageFileFactory
implements Service {
    private static final transient Logger LOG = LoggerFactory.getLogger(HawtDBFile.class);
    private static final BTreeIndexFactory<String, Integer> ROOT_INDEXES_FACTORY = new BTreeIndexFactory();
    private static final BTreeIndexFactory<Buffer, Buffer> INDEX_FACTORY = new BTreeIndexFactory();
    private TxPageFile pageFile;

    public HawtDBFile() {
        this.setSync(false);
    }

    public void start() {
        if (this.getFile() == null) {
            throw new IllegalArgumentException("A file must be configured");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting HawtDB using file: {}", (Object)this.getFile());
        }
        this.open();
        this.pageFile = this.getTxPageFile();
        this.execute(new Work<Boolean>(){

            @Override
            public Boolean execute(Transaction tx) {
                if (!tx.allocator().isAllocated(0)) {
                    ROOT_INDEXES_FACTORY.create((Paged)tx);
                    LOG.info("Aggregation repository data store created using file: " + HawtDBFile.this.getFile());
                } else {
                    SortedIndex indexes = ROOT_INDEXES_FACTORY.open((Paged)tx);
                    LOG.info("Aggregation repository data store loaded using file: " + HawtDBFile.this.getFile() + " containing " + indexes.size() + " repositories.");
                }
                return true;
            }

            public String toString() {
                return "Allocation repository file: " + HawtDBFile.this.getFile();
            }
        });
    }

    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping HawtDB using file: {}", (Object)this.getFile());
        }
        this.close();
        this.pageFile = null;
    }

    public <T> T execute(Work<T> work) {
        LOG.trace("Executing work +++ start +++ {}", work);
        Transaction tx = this.pageFile.tx();
        T answer = HawtDBFile.doExecute(work, tx, this.pageFile);
        LOG.trace("Executing work +++ done  +++ {}", work);
        return answer;
    }

    public SortedIndex<Buffer, Buffer> getRepositoryIndex(Transaction tx, String name, boolean create) {
        SortedIndex answer = null;
        SortedIndex indexes = ROOT_INDEXES_FACTORY.open((Paged)tx);
        Integer location = (Integer)indexes.get((Object)name);
        if (create && location == null) {
            SortedIndex created = INDEX_FACTORY.create((Paged)tx);
            int page = created.getIndexLocation();
            indexes.put((Object)name, (Object)page);
            LOG.debug("Created new repository index with name {} at location {}", (Object)name, (Object)page);
            answer = created;
        } else if (location != null) {
            LOG.trace("Repository index with name {} at location {}", (Object)name, (Object)location);
            answer = INDEX_FACTORY.open((Paged)tx, location.intValue());
        }
        LOG.trace("Repository index with name {} -> {}", (Object)name, answer);
        return answer;
    }

    private static <T> T doExecute(Work<T> work, Transaction tx, TxPageFile page) {
        T answer = null;
        boolean done = false;
        int attempt = 0;
        while (!done) {
            try {
                if (attempt > 0) {
                    LOG.debug("Attempt {} to execute work {}", (Object)attempt, work);
                }
                ++attempt;
                answer = work.execute(tx);
                LOG.trace("TX is read only: {} for executed work: {}", (Object)tx.isReadOnly(), work);
                tx.commit();
                page.flush();
                done = true;
            }
            catch (OptimisticUpdateException e) {
                LOG.warn("OptimisticUpdateException occurred at attempt " + attempt + " executing work " + work + ". Will do rollback and retry.");
                tx.rollback();
            }
            catch (RuntimeException e) {
                LOG.warn("Error executing work " + work + ". Will do rollback.", (Throwable)e);
                tx.rollback();
                throw e;
            }
        }
        return answer;
    }

    static {
        ROOT_INDEXES_FACTORY.setKeyCodec((Codec)StringCodec.INSTANCE);
        ROOT_INDEXES_FACTORY.setValueCodec((Codec)IntegerCodec.INSTANCE);
        ROOT_INDEXES_FACTORY.setDeferredEncoding(false);
        INDEX_FACTORY.setKeyCodec((Codec)BufferCodec.INSTANCE);
        INDEX_FACTORY.setValueCodec((Codec)BufferCodec.INSTANCE);
        INDEX_FACTORY.setDeferredEncoding(false);
    }
}

