/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.seda;

import com.hazelcast.transaction.TransactionContext;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.hazelcast.seda.HazelcastSedaEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultExchangeHolder;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastSedaConsumer
extends DefaultConsumer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(HazelcastSedaConsumer.class);
    private final HazelcastSedaEndpoint endpoint;
    private final AsyncProcessor processor;
    private ExecutorService executor;

    public HazelcastSedaConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = (HazelcastSedaEndpoint)endpoint;
        this.processor = AsyncProcessorConverterHelper.convert((Processor)processor);
    }

    protected void doStart() throws Exception {
        int concurrentConsumers = this.endpoint.getConfiguration().getConcurrentConsumers();
        this.executor = this.endpoint.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, this.endpoint.getEndpointUri(), concurrentConsumers);
        for (int i = 0; i < concurrentConsumers; ++i) {
            this.executor.execute(this);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.executor != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdown(this.executor);
            this.executor = null;
        }
        super.doStop();
    }

    @Override
    public void run() {
        BlockingQueue<Object> queue = this.endpoint.getQueue();
        while (queue != null && this.isRunAllowed()) {
            Exchange exchange = this.getEndpoint().createExchange();
            TransactionContext transactionCtx = null;
            if (this.endpoint.getConfiguration().isTransacted() && (transactionCtx = this.endpoint.getHazelcastInstance().newTransactionContext()) != null) {
                this.log.trace("Begin transaction: {}", (Object)transactionCtx.getTxnId());
                transactionCtx.beginTransaction();
            }
            try {
                block13: {
                    Object body = queue.poll(this.endpoint.getConfiguration().getPollTimeout(), TimeUnit.MILLISECONDS);
                    if (body != null) {
                        if (body instanceof DefaultExchangeHolder) {
                            DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)((DefaultExchangeHolder)body));
                        } else {
                            exchange.getIn().setBody(body);
                        }
                        try {
                            this.processor.process(exchange, new AsyncCallback(){

                                public void done(boolean asyncDone) {
                                }
                            });
                            if (exchange.getException() != null) {
                                if (transactionCtx != null) {
                                    transactionCtx.rollbackTransaction();
                                }
                                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                            }
                        }
                        catch (Exception e) {
                            LOG.error("Hzlq Exception caught: " + e, (Throwable)e);
                            if (transactionCtx == null) break block13;
                            this.log.trace("Rollback transaction: {}", (Object)transactionCtx.getTxnId());
                            transactionCtx.rollbackTransaction();
                        }
                    }
                }
                if (exchange.getException() != null || transactionCtx == null) continue;
                this.log.trace("Commit transaction: {}", (Object)transactionCtx.getTxnId());
                transactionCtx.commitTransaction();
            }
            catch (InterruptedException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Hzlq Consumer Interrupted: " + e, (Throwable)e);
            }
            catch (Throwable e) {
                if (transactionCtx != null) {
                    this.log.trace("Rollback transaction: {}", (Object)transactionCtx.getTxnId());
                    transactionCtx.rollbackTransaction();
                }
                this.getExceptionHandler().handleException("Error processing exchange", exchange, e);
            }
        }
    }
}

