/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.topic;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.component.hazelcast.HazelcastDefaultEndpoint;
import org.apache.camel.component.hazelcast.HazelcastDefaultProducer;

public class HazelcastTopicProducer
extends HazelcastDefaultProducer {
    private ITopic<Object> topic;

    public HazelcastTopicProducer(HazelcastInstance hazelcastInstance, HazelcastDefaultEndpoint endpoint, String topicName) {
        super(endpoint);
        this.topic = hazelcastInstance.getTopic(topicName);
    }

    public void process(Exchange exchange) throws Exception {
        int operation = this.lookupOperationNumber(exchange);
        switch (operation) {
            case -1: 
            case 35: {
                this.publish(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The value '%s' is not allowed for parameter '%s' on the TOPIC cache.", operation, "CamelHazelcastOperationType"));
            }
        }
        HazelcastComponentHelper.copyHeaders(exchange);
    }

    private void publish(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.topic.publish(body);
    }
}

