/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase.processor.idempotent;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.camel.component.hbase.HBaseHelper;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseIdempotentRepository
extends ServiceSupport
implements IdempotentRepository<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseIdempotentRepository.class);
    private final String tableName;
    private final String family;
    private final String qualifer;
    private final HTable table;

    public HBaseIdempotentRepository(Configuration configuration, String tableName, String family, String qualifier) throws IOException {
        this.tableName = tableName;
        this.family = family;
        this.qualifer = qualifier;
        this.table = new HTable(configuration, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object o) {
        try {
            String string = this.tableName.intern();
            synchronized (string) {
                if (this.contains(o)) {
                    return false;
                }
                byte[] b = this.toBytes(o);
                Put put = new Put(b);
                put.add(HBaseHelper.getHBaseFieldAsBytes(this.family), HBaseHelper.getHBaseFieldAsBytes(this.qualifer), b);
                this.table.put(put);
                this.table.flushCommits();
                return true;
            }
        }
        catch (Exception e) {
            LOG.warn("Error adding object {} to HBase repository.", o);
            return false;
        }
    }

    public boolean contains(Object o) {
        try {
            byte[] b = this.toBytes(o);
            Get get = new Get(b);
            get.addColumn(HBaseHelper.getHBaseFieldAsBytes(this.family), HBaseHelper.getHBaseFieldAsBytes(this.qualifer));
            return this.table.exists(get);
        }
        catch (Exception e) {
            LOG.warn("Error reading object {} from HBase repository.", o);
            return false;
        }
    }

    public boolean remove(Object o) {
        try {
            byte[] b = this.toBytes(o);
            if (this.table.exists(new Get(b))) {
                Delete delete = new Delete(b);
                this.table.delete(delete);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOG.warn("Error removing object {} from HBase repository.", o);
            return false;
        }
    }

    public boolean confirm(Object o) {
        return true;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toBytes(Object obj) {
        byte[] byArray;
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof Byte) {
            return Bytes.toBytes((short)((Byte)obj).byteValue());
        }
        if (obj instanceof Short) {
            return Bytes.toBytes((short)((Short)obj));
        }
        if (obj instanceof Integer) {
            return Bytes.toBytes((int)((Integer)obj));
        }
        if (obj instanceof Long) {
            return Bytes.toBytes((long)((Long)obj));
        }
        if (obj instanceof Double) {
            return Bytes.toBytes((double)((Double)obj));
        }
        if (obj instanceof String) {
            return Bytes.toBytes((String)((String)obj));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            byArray = baos.toByteArray();
        }
        catch (IOException e) {
            byte[] byArray2;
            try {
                LOG.warn("Error while serializing object. Null will be used.", (Throwable)e);
                byArray2 = null;
            }
            catch (Throwable throwable) {
                IOHelper.close(oos);
                IOHelper.close((Closeable)baos);
                throw throwable;
            }
            IOHelper.close((Closeable)oos);
            IOHelper.close((Closeable)baos);
            return byArray2;
        }
        IOHelper.close((Closeable)oos);
        IOHelper.close((Closeable)baos);
        return byArray;
    }
}

