/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase;

import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.hbase.HBaseComponent;
import org.apache.camel.component.hbase.HBaseConsumer;
import org.apache.camel.component.hbase.HBaseDeleteHandler;
import org.apache.camel.component.hbase.HBaseProducer;
import org.apache.camel.component.hbase.HBaseRemoveHandler;
import org.apache.camel.component.hbase.mapping.CellMappingStrategyFactory;
import org.apache.camel.component.hbase.model.HBaseRow;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.filter.Filter;

@UriEndpoint(scheme="hbase", title="HBase", syntax="hbase:tableName", consumerClass=HBaseConsumer.class, label="hadoop")
public class HBaseEndpoint
extends DefaultEndpoint {
    private Configuration configuration;
    private final HTablePool tablePool;
    private HBaseAdmin admin;
    @UriPath
    @Metadata(required="true")
    private final String tableName;
    @UriParam(defaultValue="100")
    private int maxResults = 100;
    @UriParam
    private List<Filter> filters;
    @UriParam
    private String operation;
    @UriParam(defaultValue="true")
    private boolean remove = true;
    @UriParam
    private String mappingStrategyName;
    @UriParam
    private String mappingStrategyClassName;
    @UriParam
    private CellMappingStrategyFactory cellMappingStrategyFactory = new CellMappingStrategyFactory();
    @UriParam
    private HBaseRemoveHandler removeHandler = new HBaseDeleteHandler();
    @UriParam
    private HBaseRow rowModel;
    @UriParam
    private int maxMessagesPerPoll;

    public HBaseEndpoint(String uri, HBaseComponent component, HTablePool tablePool, String tableName) {
        super(uri, (Component)component);
        this.tableName = tableName;
        this.tablePool = tablePool;
        if (this.tableName == null) {
            throw new IllegalArgumentException("Table name can not be null");
        }
    }

    public Producer createProducer() throws Exception {
        return new HBaseProducer(this, this.tablePool, this.tableName);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        HBaseConsumer consumer = new HBaseConsumer(this, processor, this.tablePool, this.tableName);
        this.configureConsumer((Consumer)consumer);
        consumer.setMaxMessagesPerPoll(this.maxMessagesPerPoll);
        return consumer;
    }

    public boolean isSingleton() {
        return true;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public HBaseAdmin getAdmin() {
        return this.admin;
    }

    public void setAdmin(HBaseAdmin admin) {
        this.admin = admin;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public CellMappingStrategyFactory getCellMappingStrategyFactory() {
        return this.cellMappingStrategyFactory;
    }

    public void setCellMappingStrategyFactory(CellMappingStrategyFactory cellMappingStrategyFactory) {
        this.cellMappingStrategyFactory = cellMappingStrategyFactory;
    }

    public String getMappingStrategyName() {
        return this.mappingStrategyName;
    }

    public void setMappingStrategyName(String mappingStrategyName) {
        this.mappingStrategyName = mappingStrategyName;
    }

    public String getMappingStrategyClassName() {
        return this.mappingStrategyClassName;
    }

    public void setMappingStrategyClassName(String mappingStrategyClassName) {
        this.mappingStrategyClassName = mappingStrategyClassName;
    }

    public HBaseRow getRowModel() {
        return this.rowModel;
    }

    public void setRowModel(HBaseRow rowModel) {
        this.rowModel = rowModel;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public HBaseRemoveHandler getRemoveHandler() {
        return this.removeHandler;
    }

    public void setRemoveHandler(HBaseRemoveHandler removeHandler) {
        this.removeHandler = removeHandler;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }
}

