/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.hdfs.HdfsConfiguration;
import org.apache.camel.component.hdfs.HdfsConsumer;
import org.apache.camel.component.hdfs.HdfsProducer;
import org.apache.camel.impl.DefaultEndpoint;

public class HdfsEndpoint
extends DefaultEndpoint {
    private final HdfsConfiguration config = new HdfsConfiguration();

    public HdfsEndpoint(String endpointUri, CamelContext context) throws URISyntaxException {
        super(endpointUri, context);
        this.config.parseURI(new URI(endpointUri));
    }

    public Consumer createConsumer(Processor processor) {
        this.config.checkConsumerOptions();
        return new HdfsConsumer(this, processor, this.config);
    }

    public Producer createProducer() {
        this.config.checkProducerOptions();
        return new HdfsProducer(this, this.config);
    }

    public boolean isSingleton() {
        return true;
    }

    public HdfsConfiguration getConfig() {
        return this.config;
    }
}

