/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapClientBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.ibatis.IBatisEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class IBatisComponent
extends DefaultComponent {
    public static final String DEFAULT_CONFIG_URI = "SqlMapConfig.xml";
    private static final transient Log LOG = LogFactory.getLog(IBatisComponent.class);
    private SqlMapClient sqlMapClient;
    private Resource sqlMapResource;

    public IBatisComponent() {
    }

    public IBatisComponent(SqlMapClient sqlMapClient) {
        this.sqlMapClient = sqlMapClient;
    }

    public SqlMapClient getSqlMapClient() throws IOException {
        if (this.sqlMapClient == null) {
            this.sqlMapClient = this.createSqlMapClient();
        }
        return this.sqlMapClient;
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClient = sqlMapClient;
    }

    public Resource getSqlMapResource() {
        if (this.sqlMapResource == null) {
            this.sqlMapResource = new ClassPathResource(DEFAULT_CONFIG_URI);
            LOG.debug((Object)("Defaulting to use the iBatis configuration from: " + this.sqlMapResource));
        }
        return this.sqlMapResource;
    }

    public void setSqlMapResource(Resource sqlMapResource) {
        this.sqlMapResource = sqlMapResource;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        return new IBatisEndpoint(uri, this, remaining);
    }

    protected SqlMapClient createSqlMapClient() throws IOException {
        InputStream in = this.getSqlMapResource().getInputStream();
        return SqlMapClientBuilder.buildSqlMapClient((InputStream)in);
    }
}

