/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.Message;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Producer;
import org.apache.camel.component.ibatis.IBatisComponent;
import org.apache.camel.component.ibatis.IBatisPollingConsumer;
import org.apache.camel.component.ibatis.IBatisProducer;
import org.apache.camel.component.ibatis.StatementType;
import org.apache.camel.impl.DefaultPollingEndpoint;
import org.apache.camel.util.ObjectHelper;

public class IBatisEndpoint
extends DefaultPollingEndpoint {
    private final String entityName;
    private StatementType statementType;

    public IBatisEndpoint(String endpointUri, IBatisComponent component, String entityName) {
        super(endpointUri, (Component)component);
        this.entityName = entityName;
    }

    public IBatisEndpoint(String endpointUri, String entityName) {
        super(endpointUri);
        this.entityName = entityName;
    }

    public IBatisComponent getComponent() {
        return (IBatisComponent)super.getComponent();
    }

    public boolean isSingleton() {
        return true;
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)((Object)this.statementType), (String)"statementType", (Object)((Object)this));
        return new IBatisProducer(this);
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        return new IBatisPollingConsumer(this);
    }

    public SqlMapClient getSqlClient() throws IOException {
        return this.getComponent().getSqlMapClient();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void query(Message message) throws IOException, SQLException {
        String name = this.getEntityName();
        List list = this.getSqlClient().queryForList(name);
        message.setBody((Object)list);
        message.setHeader("org.apache.camel.ibatis.queryName", (Object)name);
    }

    public StatementType getStatementType() {
        return this.statementType;
    }

    public void setStatementType(StatementType statementType) {
        this.statementType = statementType;
    }
}

