/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.ibatis.IBatisEndpoint;
import org.apache.camel.component.ibatis.StatementType;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IBatisProducer
extends DefaultProducer {
    private static final Log LOG = LogFactory.getLog(IBatisProducer.class);
    private String statement;
    private final IBatisEndpoint endpoint;

    public IBatisProducer(IBatisEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.statement = endpoint.getEntityName();
    }

    public IBatisEndpoint getEndpoint() {
        return (IBatisEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.endpoint.getStatementType()) {
            case QueryForObject: {
                this.doQueryForObject(exchange);
                break;
            }
            case QueryForList: {
                this.doQueryForList(exchange);
                break;
            }
            case Insert: {
                this.doInsert(exchange);
                break;
            }
            case Update: {
                this.doUpdate(exchange);
                break;
            }
            case Delete: {
                this.doDelete(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported statementType: " + (Object)((Object)this.endpoint.getStatementType()));
            }
        }
    }

    private void doQueryForObject(Exchange exchange) throws Exception {
        Object result;
        SqlMapClient client = this.endpoint.getSqlClient();
        Object in = exchange.getIn().getBody();
        if (in != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("QueryForObject: " + in + "  using statement: " + this.statement));
            }
            result = client.queryForObject(this.statement, in);
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("QueryForObject using statement: " + this.statement));
            }
            result = client.queryForObject(this.statement);
        }
        this.doProcessResult(exchange, result);
    }

    private void doQueryForList(Exchange exchange) throws Exception {
        List result;
        SqlMapClient client = this.endpoint.getSqlClient();
        Object in = exchange.getIn().getBody();
        if (in != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("QueryForList: " + in + "  using statement: " + this.statement));
            }
            result = client.queryForList(this.statement, in);
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("QueryForList using statement: " + this.statement));
            }
            result = client.queryForList(this.statement);
        }
        this.doProcessResult(exchange, result);
    }

    private void doInsert(Exchange exchange) throws Exception {
        SqlMapClient client = this.endpoint.getSqlClient();
        Object in = exchange.getIn().getBody();
        if (in != null) {
            Iterator iter = ObjectHelper.createIterator((Object)in);
            while (iter.hasNext()) {
                Object value = iter.next();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Inserting: " + value + " using statement: " + this.statement));
                }
                Object result = client.insert(this.statement, value);
                this.doProcessResult(exchange, result);
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Inserting using statement: " + this.statement));
            }
            Object result = client.insert(this.statement);
            this.doProcessResult(exchange, result);
        }
    }

    private void doUpdate(Exchange exchange) throws Exception {
        SqlMapClient client = this.endpoint.getSqlClient();
        Object in = exchange.getIn().getBody();
        if (in != null) {
            Iterator iter = ObjectHelper.createIterator((Object)in);
            while (iter.hasNext()) {
                Object value = iter.next();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Updating: " + value + " using statement: " + this.statement));
                }
                Integer result = client.update(this.statement, value);
                this.doProcessResult(exchange, result);
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Updating using statement: " + this.statement));
            }
            Integer result = client.update(this.statement);
            this.doProcessResult(exchange, result);
        }
    }

    private void doDelete(Exchange exchange) throws Exception {
        SqlMapClient client = this.endpoint.getSqlClient();
        Object in = exchange.getIn().getBody();
        if (in != null) {
            Iterator iter = ObjectHelper.createIterator((Object)in);
            while (iter.hasNext()) {
                Object value = iter.next();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Deleting: " + value + " using statement: " + this.statement));
                }
                Integer result = client.delete(this.statement, value);
                this.doProcessResult(exchange, result);
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Deleting using statement: " + this.statement));
            }
            Integer result = client.delete(this.statement);
            this.doProcessResult(exchange, result);
        }
    }

    private void doProcessResult(Exchange exchange, Object result) {
        if (this.endpoint.getStatementType() == StatementType.QueryForList || this.endpoint.getStatementType() == StatementType.QueryForObject) {
            Message answer = exchange.getIn();
            if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
                answer = exchange.getOut();
                answer.getHeaders().putAll(exchange.getIn().getHeaders());
            }
            answer.setBody(result);
            answer.setHeader("CamelIBatisResult", result);
            answer.setHeader("CamelIBatisStatementName", (Object)this.statement);
            answer.setHeader("org.apache.camel.ibatis.queryName", (Object)this.statement);
        } else {
            Message msg = exchange.getIn();
            msg.setHeader("CamelIBatisResult", result);
            msg.setHeader("CamelIBatisStatementName", (Object)this.statement);
            msg.setHeader("org.apache.camel.ibatis.queryName", (Object)this.statement);
        }
    }
}

