/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ibatis.strategy;

import com.ibatis.sqlmap.client.SqlMapClient;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.ibatis.IBatisEndpoint;
import org.apache.camel.component.ibatis.IBatisPollingConsumer;
import org.apache.camel.component.ibatis.strategy.IBatisProcessingStrategy;

public class DefaultIBatisProcessingStategy
implements IBatisProcessingStrategy {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(IBatisEndpoint endpoint, Exchange exchange, Object data, String consumeStatements) throws Exception {
        SqlMapClient client = endpoint.getSqlMapClient();
        boolean useTrans = endpoint.isUseTransactions();
        String[] statements = consumeStatements.split(",");
        try {
            if (useTrans) {
                client.startTransaction(4);
            }
            for (String statement : statements) {
                client.update(statement.trim(), data);
            }
            if (useTrans) {
                client.commitTransaction();
            }
        }
        finally {
            if (useTrans) {
                client.endTransaction();
            }
        }
    }

    public List poll(IBatisPollingConsumer consumer, IBatisEndpoint endpoint) throws Exception {
        SqlMapClient client = endpoint.getSqlMapClient();
        return client.queryForList(endpoint.getStatement(), null);
    }
}

