/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import java.io.IOException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ibatis.IBatisComponent;
import org.apache.camel.component.ibatis.IBatisPollingConsumer;
import org.apache.camel.component.ibatis.IBatisProducer;
import org.apache.camel.component.ibatis.StatementType;
import org.apache.camel.component.ibatis.strategy.DefaultIBatisProcessingStategy;
import org.apache.camel.component.ibatis.strategy.IBatisProcessingStrategy;
import org.apache.camel.impl.DefaultPollingEndpoint;
import org.apache.camel.util.ObjectHelper;

public class IBatisEndpoint
extends DefaultPollingEndpoint {
    private IBatisProcessingStrategy strategy;
    private boolean useTransactions;
    private String statement;
    private StatementType statementType;
    private int maxMessagesPerPoll;

    public IBatisEndpoint() {
    }

    public IBatisEndpoint(String uri, IBatisComponent component, String statement) throws Exception {
        super(uri, (Component)component);
        this.setUseTransactions(component.isUseTransactions());
        this.setStatement(statement);
    }

    public IBatisComponent getComponent() {
        return (IBatisComponent)super.getComponent();
    }

    public boolean isSingleton() {
        return true;
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)((Object)this.statementType), (String)"statementType", (Object)((Object)this));
        return new IBatisProducer(this);
    }

    public IBatisPollingConsumer createConsumer(Processor processor) throws Exception {
        IBatisPollingConsumer consumer = new IBatisPollingConsumer(this, processor);
        consumer.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public SqlMapClient getSqlMapClient() throws IOException {
        return this.getComponent().getSqlMapClient();
    }

    public IBatisProcessingStrategy getProcessingStrategy() throws Exception {
        if (this.strategy == null) {
            this.strategy = new DefaultIBatisProcessingStategy();
        }
        return this.strategy;
    }

    public void setStrategy(IBatisProcessingStrategy strategy) {
        this.strategy = strategy;
    }

    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String statement) {
        this.statement = statement;
    }

    public boolean isUseTransactions() {
        return this.useTransactions;
    }

    public void setUseTransactions(boolean useTransactions) {
        this.useTransactions = useTransactions;
    }

    public StatementType getStatementType() {
        return this.statementType;
    }

    public void setStatementType(StatementType statementType) {
        this.statementType = statementType;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }
}

