/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapClientBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.camel.component.ibatis.IBatisEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.ResourceHelper;

public class IBatisComponent
extends DefaultComponent {
    private static final String DEFAULT_CONFIG_URI = "classpath:SqlMapConfig.xml";
    private SqlMapClient sqlMapClient;
    private String sqlMapConfig = "classpath:SqlMapConfig.xml";
    private boolean useTransactions = true;

    public IBatisComponent() {
    }

    public IBatisComponent(SqlMapClient sqlMapClient) {
        this.sqlMapClient = sqlMapClient;
    }

    protected IBatisEndpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        IBatisEndpoint answer = new IBatisEndpoint(uri, this, remaining);
        this.setProperties((Object)answer, parameters);
        return answer;
    }

    private SqlMapClient createSqlMapClient() throws IOException {
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)this.getCamelContext().getClassResolver(), (String)this.sqlMapConfig);
        return SqlMapClientBuilder.buildSqlMapClient((InputStream)is);
    }

    public SqlMapClient getSqlMapClient() throws IOException {
        if (this.sqlMapClient == null) {
            this.sqlMapClient = this.createSqlMapClient();
        }
        return this.sqlMapClient;
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClient = sqlMapClient;
    }

    public String getSqlMapConfig() {
        return this.sqlMapConfig;
    }

    public void setSqlMapConfig(String sqlMapConfig) {
        this.sqlMapConfig = sqlMapConfig;
    }

    public boolean isUseTransactions() {
        return this.useTransactions;
    }

    public void setUseTransactions(boolean useTransactions) {
        this.useTransactions = useTransactions;
    }
}

