/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ibatis;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.camel.BatchConsumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.component.ibatis.IBatisEndpoint;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IBatisConsumer
extends ScheduledPollConsumer
implements BatchConsumer,
ShutdownAware {
    private static final Logger LOG = LoggerFactory.getLogger(IBatisConsumer.class);
    protected volatile ShutdownRunningTask shutdownRunningTask;
    protected volatile int pendingExchanges;
    private String onConsume;
    private boolean useIterator = true;
    private boolean routeEmptyResultSet;
    private int maxMessagesPerPoll;

    public IBatisConsumer(IBatisEndpoint endpoint, Processor processor) throws Exception {
        super((Endpoint)endpoint, processor);
    }

    public IBatisEndpoint getEndpoint() {
        return (IBatisEndpoint)super.getEndpoint();
    }

    protected int poll() throws Exception {
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        IBatisEndpoint endpoint = this.getEndpoint();
        LOG.trace("Polling: {}", (Object)endpoint);
        List data = CastUtils.cast((List)endpoint.getProcessingStrategy().poll(this, this.getEndpoint()));
        LinkedList<DataHolder> answer = new LinkedList<DataHolder>();
        if (this.useIterator) {
            for (Object item : data) {
                Exchange exchange = this.createExchange(item);
                DataHolder holder = new DataHolder();
                holder.exchange = exchange;
                holder.data = item;
                answer.add(holder);
            }
        } else if (!data.isEmpty() || this.routeEmptyResultSet) {
            Exchange exchange = this.createExchange(data);
            DataHolder holder = new DataHolder();
            holder.exchange = exchange;
            holder.data = data;
            answer.add(holder);
        }
        return this.processBatch(CastUtils.cast(answer));
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        IBatisEndpoint endpoint = this.getEndpoint();
        int total = exchanges.size();
        if (this.maxMessagesPerPoll > 0 && total > this.maxMessagesPerPoll) {
            LOG.debug("Limiting to maximum messages to poll " + this.maxMessagesPerPoll + " as there was " + total + " messages in this poll.");
            total = this.maxMessagesPerPoll;
        }
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            DataHolder holder = (DataHolder)ObjectHelper.cast(DataHolder.class, (Object)exchanges.poll());
            Exchange exchange = holder.exchange;
            Object data = holder.data;
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            LOG.debug("Processing exchange: {}", (Object)exchange);
            this.getProcessor().process(exchange);
            try {
                if (this.onConsume == null) continue;
                endpoint.getProcessingStrategy().commit(endpoint, exchange, data, this.onConsume);
                continue;
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return total;
    }

    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
        return false;
    }

    public int getPendingExchangesSize() {
        int answer = ShutdownRunningTask.CompleteAllTasks == this.shutdownRunningTask ? this.pendingExchanges : 0;
        if (answer == 0 && this.isPolling()) {
            this.log.trace("Currently polling so returning 1 as pending exchanges");
            answer = 1;
        }
        return answer;
    }

    public void prepareShutdown(boolean forced) {
    }

    public boolean isBatchAllowed() {
        boolean answer = this.isRunAllowed();
        if (!answer) {
            return false;
        }
        if (this.shutdownRunningTask == null) {
            return true;
        }
        return ShutdownRunningTask.CompleteAllTasks == this.shutdownRunningTask;
    }

    private Exchange createExchange(Object data) {
        IBatisEndpoint endpoint = this.getEndpoint();
        Exchange exchange = endpoint.createExchange(ExchangePattern.InOnly);
        Message msg = exchange.getIn();
        msg.setBody(data);
        msg.setHeader("CamelIBatisStatementName", (Object)endpoint.getStatement());
        return exchange;
    }

    public String getOnConsume() {
        return this.onConsume;
    }

    public void setOnConsume(String onConsume) {
        this.onConsume = onConsume;
    }

    public boolean isUseIterator() {
        return this.useIterator;
    }

    public void setUseIterator(boolean useIterator) {
        this.useIterator = useIterator;
    }

    public boolean isRouteEmptyResultSet() {
        return this.routeEmptyResultSet;
    }

    public void setRouteEmptyResultSet(boolean routeEmptyResultSet) {
        this.routeEmptyResultSet = routeEmptyResultSet;
    }

    private static final class DataHolder {
        private Exchange exchange;
        private Object data;

        private DataHolder() {
        }
    }
}

