/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.irc.IrcConfiguration;
import org.apache.camel.component.irc.IrcEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.IRCEventAdapter;
import org.schwering.irc.lib.IRCEventListener;
import org.schwering.irc.lib.IRCModeParser;
import org.schwering.irc.lib.IRCUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IrcConsumer
extends DefaultConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(IrcConsumer.class);
    private final IrcConfiguration configuration;
    private final IrcEndpoint endpoint;
    private final IRCConnection connection;
    private IRCEventAdapter listener;

    public IrcConsumer(IrcEndpoint endpoint, Processor processor, IRCConnection connection) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.connection = connection;
        this.configuration = endpoint.getConfiguration();
    }

    protected void doStop() throws Exception {
        if (this.connection != null) {
            for (String channel : this.endpoint.getConfiguration().getChannels()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Parting: " + channel);
                }
                this.connection.doPart(channel);
            }
            this.connection.removeIRCEventListener((IRCEventListener)this.listener);
        }
        super.doStop();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.listener = this.getListener();
        this.connection.addIRCEventListener((IRCEventListener)this.listener);
        this.endpoint.joinChannels();
    }

    public IRCConnection getConnection() {
        return this.connection;
    }

    public IRCEventAdapter getListener() {
        if (this.listener == null) {
            this.listener = new FilteredIRCEventAdapter();
        }
        return this.listener;
    }

    public void setListener(IRCEventAdapter listener) {
        this.listener = listener;
    }

    class FilteredIRCEventAdapter
    extends IRCEventAdapter {
        FilteredIRCEventAdapter() {
        }

        public void onNick(IRCUser user, String newNick) {
            if (IrcConsumer.this.configuration.isOnNick()) {
                Exchange exchange = IrcConsumer.this.endpoint.createOnNickExchange(user, newNick);
                try {
                    IrcConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    IrcConsumer.this.handleException(e);
                }
            }
        }

        public void onQuit(IRCUser user, String msg) {
            if (IrcConsumer.this.configuration.isOnQuit()) {
                Exchange exchange = IrcConsumer.this.endpoint.createOnQuitExchange(user, msg);
                try {
                    IrcConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    IrcConsumer.this.handleException(e);
                }
            }
        }

        public void onJoin(String channel, IRCUser user) {
            if (IrcConsumer.this.configuration.isOnJoin()) {
                Exchange exchange = IrcConsumer.this.endpoint.createOnJoinExchange(channel, user);
                try {
                    IrcConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    IrcConsumer.this.handleException(e);
                }
            }
        }

        public void onKick(String channel, IRCUser user, String passiveNick, String msg) {
            if (passiveNick.equals(IrcConsumer.this.connection.getNick()) && IrcConsumer.this.configuration.isAutoRejoin()) {
                IrcConsumer.this.endpoint.joinChannel(channel);
            }
            if (IrcConsumer.this.configuration.isOnKick()) {
                Exchange exchange = IrcConsumer.this.endpoint.createOnKickExchange(channel, user, passiveNick, msg);
                try {
                    IrcConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    IrcConsumer.this.handleException(e);
                }
            }
        }

        public void onMode(String channel, IRCUser user, IRCModeParser modeParser) {
            if (IrcConsumer.this.configuration.isOnMode()) {
                Exchange exchange = IrcConsumer.this.endpoint.createOnModeExchange(channel, user, modeParser);
                try {
                    IrcConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    IrcConsumer.this.handleException(e);
                }
            }
        }

        public void onPart(String channel, IRCUser user, String msg) {
            if (IrcConsumer.this.configuration.isOnPart()) {
                Exchange exchange = IrcConsumer.this.endpoint.createOnPartExchange(channel, user, msg);
                try {
                    IrcConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    IrcConsumer.this.handleException(e);
                }
            }
        }

        public void onReply(int num, String value, String msg) {
            if (IrcConsumer.this.configuration.isOnReply()) {
                Exchange exchange = IrcConsumer.this.endpoint.createOnReplyExchange(num, value, msg);
                try {
                    IrcConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    IrcConsumer.this.handleException(e);
                }
            }
        }

        public void onTopic(String channel, IRCUser user, String topic) {
            if (IrcConsumer.this.configuration.isOnTopic()) {
                Exchange exchange = IrcConsumer.this.endpoint.createOnTopicExchange(channel, user, topic);
                try {
                    IrcConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    IrcConsumer.this.handleException(e);
                }
            }
        }

        public void onPrivmsg(String target, IRCUser user, String msg) {
            if (IrcConsumer.this.configuration.isOnPrivmsg()) {
                Exchange exchange = IrcConsumer.this.endpoint.createOnPrivmsgExchange(target, user, msg);
                try {
                    IrcConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    IrcConsumer.this.handleException(e);
                }
            }
        }

        public void onError(int num, String msg) {
        }
    }
}

