/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tests.component;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;

public class PerformanceTestComponent
extends DefaultComponent {
    public static final String HEADER_THREADS = "CamelPerfThreads";
    public static final String HEADER_ITERATIONS = "CamelPerfIterations";
    private static final int DEFAULT_THREADS = 8;
    private static final int DEFAULT_ITERATIONS = 100;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        PerformanceTestEndpoint endpoint = new PerformanceTestEndpoint(uri, (Component)this);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    public static int getHeaderValue(Exchange exchange, String header) {
        Integer value = (Integer)exchange.getContext().getTypeConverter().convertTo(Integer.class, exchange, exchange.getIn().getHeader(header));
        return value != null ? value : (header.equals(HEADER_THREADS) ? 8 : (header.equals(HEADER_ITERATIONS) ? 100 : 0));
    }

    private static final class PerformanceTestProducer
    extends DefaultProducer
    implements AsyncProcessor {
        public PerformanceTestProducer(Endpoint endpoint) {
            super(endpoint);
        }

        public void process(final Exchange exchange) throws Exception {
            int count = PerformanceTestComponent.getHeaderValue(exchange, PerformanceTestComponent.HEADER_ITERATIONS);
            int threads = PerformanceTestComponent.getHeaderValue(exchange, PerformanceTestComponent.HEADER_THREADS);
            PerformanceTestEndpoint endpoint = (PerformanceTestEndpoint)this.getEndpoint();
            if (endpoint != null) {
                int i;
                final DefaultConsumer consumer = (DefaultConsumer)endpoint.getConsumer();
                ExecutorService executor = exchange.getContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "perf", threads);
                ExecutorCompletionService<Exchange> tasks = new ExecutorCompletionService<Exchange>(executor);
                for (i = 0; i < count; ++i) {
                    tasks.submit(new Callable<Exchange>(){

                        @Override
                        public Exchange call() throws Exception {
                            Exchange exch = ExchangeHelper.createCopy((Exchange)exchange, (boolean)false);
                            try {
                                consumer.getProcessor().process(exch);
                            }
                            catch (Exception e) {
                                exch.setException((Throwable)e);
                            }
                            return exch;
                        }
                    });
                }
                for (i = 0; i < count; ++i) {
                    tasks.take();
                }
            }
        }

        public boolean process(Exchange exchange, AsyncCallback callback) {
            try {
                this.process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            callback.done(true);
            return true;
        }
    }

    private static final class PerformanceTestConsumer
    extends DefaultConsumer {
        public PerformanceTestConsumer(Endpoint endpoint, Processor processor) {
            super(endpoint, processor);
        }
    }

    private static final class PerformanceTestEndpoint
    extends DefaultEndpoint {
        private PerformanceTestConsumer consumer;

        public PerformanceTestEndpoint(String uri, Component component) {
            super(uri, component);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Consumer createConsumer(Processor processor) throws Exception {
            PerformanceTestEndpoint performanceTestEndpoint = this;
            synchronized (performanceTestEndpoint) {
                if (this.consumer != null && processor != this.consumer.getProcessor()) {
                    throw new Exception("PerformanceTestEndpoint doesn not support multiple consumers per Endpoint");
                }
                this.consumer = new PerformanceTestConsumer((Endpoint)this, processor);
            }
            return this.consumer;
        }

        public Producer createProducer() throws Exception {
            return new PerformanceTestProducer((Endpoint)this);
        }

        public boolean isSingleton() {
            return true;
        }

        public Consumer getConsumer() {
            return this.consumer;
        }
    }
}

