/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jasypt;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.component.properties.DefaultPropertiesParser;
import org.apache.camel.util.ObjectHelper;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;

public class JasyptPropertiesParser
extends DefaultPropertiesParser {
    public static final String JASYPT_PREFIX_TOKEN = "ENC(";
    public static final String JASYPT_SUFFIX_TOKEN = ")";
    private StringEncryptor encryptor;
    private String password;
    private String algorithm;
    private Pattern pattern;

    public JasyptPropertiesParser() {
        String regex = JASYPT_PREFIX_TOKEN.replace("(", "\\(") + "(.+?)" + JASYPT_SUFFIX_TOKEN.replace(JASYPT_SUFFIX_TOKEN, "\\)");
        this.pattern = Pattern.compile(regex);
    }

    public String parseProperty(String key, String value, Properties properties) {
        this.log.trace(String.format("Parsing property '%s=%s'", key, value));
        if (value != null) {
            this.initEncryptor();
            Matcher matcher = this.pattern.matcher(value);
            while (matcher.find()) {
                this.log.trace(String.format("Decrypting part '%s'", matcher.group(0)));
                String decrypted = this.encryptor.decrypt(matcher.group(1));
                value = value.replace(matcher.group(0), decrypted);
            }
        }
        return value;
    }

    private synchronized void initEncryptor() {
        if (this.encryptor == null) {
            ObjectHelper.notEmpty((String)"password", (String)this.password);
            StandardPBEStringEncryptor pbeStringEncryptor = new StandardPBEStringEncryptor();
            pbeStringEncryptor.setPassword(this.password);
            if (this.algorithm != null) {
                pbeStringEncryptor.setAlgorithm(this.algorithm);
                this.log.debug(String.format("Initialized encryptor using %s algorithm and provided password", this.algorithm));
            } else {
                this.log.debug(String.format("Initialized encryptor using default algorithm and provided password", new Object[0]));
            }
            this.encryptor = pbeStringEncryptor;
        }
    }

    public void setEncryptor(StringEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setPassword(String password) {
        if (password.startsWith("sysenv:")) {
            password = System.getenv(ObjectHelper.after((String)password, (String)"sysenv:"));
        }
        if (password.startsWith("sys:")) {
            password = System.getProperty(ObjectHelper.after((String)password, (String)"sys:"));
        }
        this.password = password;
    }
}

