/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jasypt;

import org.apache.camel.component.properties.DefaultPropertiesParser;
import org.apache.camel.util.ObjectHelper;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;

public class JasyptPropertiesParser
extends DefaultPropertiesParser {
    public static final String JASYPT_PREFIX_TOKEN = "ENC(";
    public static final String JASYPT_SUFFIX_TOKEN = ")";
    private StandardPBEStringEncryptor encryptor;
    private String password;
    private String algorithm;

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (password.startsWith("sysenv:")) {
            password = System.getenv(ObjectHelper.after((String)password, (String)"sysenv:"));
        }
        if (password.startsWith("sys:")) {
            password = System.getProperty(ObjectHelper.after((String)password, (String)"sys:"));
        }
        this.password = password;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public synchronized StandardPBEStringEncryptor getEncryptor() {
        if (this.encryptor == null) {
            ObjectHelper.notEmpty((String)"password", (String)this.getPassword());
            this.encryptor = new StandardPBEStringEncryptor();
            this.encryptor.setPassword(this.getPassword());
            if (this.algorithm != null) {
                this.encryptor.setAlgorithm(this.getAlgorithm());
            }
        }
        return this.encryptor;
    }

    public String parsePropertyValue(String value) {
        String text = ObjectHelper.between((String)value, (String)JASYPT_PREFIX_TOKEN, (String)JASYPT_SUFFIX_TOKEN);
        if (text == null) {
            return value;
        }
        return this.getEncryptor().decrypt(text);
    }
}

