/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.ConnectionReleaser;
import org.apache.geronimo.connector.ConnectorTransactionContext;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.TxUtil;

public class TransactionCachingInterceptor
implements ConnectionInterceptor,
ConnectionReleaser {
    protected static Log log = LogFactory.getLog((String)TransactionCachingInterceptor.class.getName());
    private final ConnectionInterceptor next;
    private final TransactionManager transactionManager;

    public TransactionCachingInterceptor(ConnectionInterceptor next, TransactionManager transactionManager) {
        this.next = next;
        this.transactionManager = transactionManager;
    }

    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        Transaction transaction = TxUtil.getTransactionIfActive(this.transactionManager);
        if (transaction != null) {
            ManagedConnectionInfos managedConnectionInfos = ConnectorTransactionContext.get(transaction, this);
            if (connectionInfo.isUnshareable()) {
                if (!managedConnectionInfos.containsUnshared(connectionInfo.getManagedConnectionInfo())) {
                    this.next.getConnection(connectionInfo);
                    managedConnectionInfos.addUnshared(connectionInfo.getManagedConnectionInfo());
                }
            } else {
                ManagedConnectionInfo managedConnectionInfo = managedConnectionInfos.getShared();
                if (managedConnectionInfo != null) {
                    connectionInfo.setManagedConnectionInfo(managedConnectionInfo);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("supplying connection from tx cache " + connectionInfo.getConnectionHandle() + " for managed connection " + connectionInfo.getManagedConnectionInfo().getManagedConnection() + " to tx caching interceptor " + this));
                    }
                } else {
                    this.next.getConnection(connectionInfo);
                    managedConnectionInfos.setShared(connectionInfo.getManagedConnectionInfo());
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("supplying connection from pool " + connectionInfo.getConnectionHandle() + " for managed connection " + connectionInfo.getManagedConnectionInfo().getManagedConnection() + " to tx caching interceptor " + this));
                    }
                }
            }
        } else {
            this.next.getConnection(connectionInfo);
        }
    }

    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        if (connectionReturnAction == ConnectionReturnAction.DESTROY) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("destroying connection" + connectionInfo.getConnectionHandle() + " for managed connection " + connectionInfo.getManagedConnectionInfo().getManagedConnection() + " to tx caching interceptor " + this));
            }
            this.next.returnConnection(connectionInfo, connectionReturnAction);
            return;
        }
        try {
            Transaction transaction = this.transactionManager.getTransaction();
            if (transaction != null) {
                if (TxUtil.isActive(transaction)) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("tx active, not returning connection" + connectionInfo.getConnectionHandle() + " for managed connection " + connectionInfo.getManagedConnectionInfo().getManagedConnection() + " to tx caching interceptor " + this));
                    }
                    return;
                }
                ManagedConnectionInfos managedConnectionInfos = ConnectorTransactionContext.get(transaction, this);
                managedConnectionInfos.remove(connectionInfo.getManagedConnectionInfo());
                if (log.isTraceEnabled()) {
                    log.trace((Object)"tx ended, but not removed");
                }
            }
        }
        catch (SystemException e) {
            // empty catch block
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("tx ended, returning connection" + connectionInfo.getConnectionHandle() + " for managed connection " + connectionInfo.getManagedConnectionInfo().getManagedConnection() + " to tx caching interceptor " + this));
        }
        this.internalReturn(connectionInfo, connectionReturnAction);
    }

    private void internalReturn(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        if (connectionInfo.getManagedConnectionInfo().hasConnectionHandles()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("not returning connection from tx cache (has handles) " + connectionInfo.getConnectionHandle() + " for managed connection " + connectionInfo.getManagedConnectionInfo().getManagedConnection() + " to tx caching interceptor " + this));
            }
            return;
        }
        this.next.returnConnection(connectionInfo, connectionReturnAction);
        if (log.isTraceEnabled()) {
            log.trace((Object)("completed return of connection through tx cache " + connectionInfo.getConnectionHandle() + " for MCI: " + connectionInfo.getManagedConnectionInfo() + " and MC " + connectionInfo.getManagedConnectionInfo().getManagedConnection() + " to tx caching interceptor " + this));
        }
    }

    public void destroy() {
        this.next.destroy();
    }

    public void afterCompletion(Object stuff) {
        ManagedConnectionInfos managedConnectionInfos = (ManagedConnectionInfos)stuff;
        ManagedConnectionInfo sharedMCI = managedConnectionInfos.getShared();
        if (sharedMCI != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Transaction completed, attempting to return shared connection MCI: " + sharedMCI + " for managed connection " + sharedMCI.getManagedConnection() + " to tx caching interceptor " + this));
            }
            this.returnHandle(sharedMCI);
        }
        Iterator iterator = managedConnectionInfos.getUnshared().iterator();
        while (iterator.hasNext()) {
            ManagedConnectionInfo managedConnectionInfo = (ManagedConnectionInfo)iterator.next();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Transaction completed, attempting to return unshared connection MCI: " + managedConnectionInfo + " for managed connection " + managedConnectionInfo.getManagedConnection() + " to tx caching interceptor " + this));
            }
            this.returnHandle(managedConnectionInfo);
        }
    }

    private void returnHandle(ManagedConnectionInfo managedConnectionInfo) {
        ConnectionInfo connectionInfo = new ConnectionInfo();
        connectionInfo.setManagedConnectionInfo(managedConnectionInfo);
        this.internalReturn(connectionInfo, ConnectionReturnAction.RETURN_HANDLE);
    }

    public static class ManagedConnectionInfos {
        private ManagedConnectionInfo shared;
        private Set unshared = Collections.EMPTY_SET;

        public ManagedConnectionInfo getShared() {
            return this.shared;
        }

        public void setShared(ManagedConnectionInfo shared) {
            this.shared = shared;
        }

        public Set getUnshared() {
            return this.unshared;
        }

        public void addUnshared(ManagedConnectionInfo unsharedMCI) {
            if (this.unshared == Collections.EMPTY_SET) {
                this.unshared = new HashSet();
            }
            this.unshared.add(unsharedMCI);
        }

        public boolean containsUnshared(ManagedConnectionInfo unsharedMCI) {
            return this.unshared.contains(unsharedMCI);
        }

        public void remove(ManagedConnectionInfo managedConnectionInfo) {
            if (this.shared == managedConnectionInfo) {
                this.shared = null;
            } else {
                this.unshared.remove(managedConnectionInfo);
            }
        }
    }
}

