/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.cursors.AbstractPendingMessageCursor;

public class VMPendingMessageCursor
extends AbstractPendingMessageCursor {
    private LinkedList list = new LinkedList();
    private Iterator iter = null;
    private int[] priorities = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void reset() {
        this.iter = this.list.listIterator();
    }

    public void addMessageLast(MessageReference node) {
        this.list.addLast(node);
    }

    public void addMessageFirst(MessageReference node) {
        this.list.addFirst(node);
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public MessageReference next() {
        return (MessageReference)this.iter.next();
    }

    public void remove() {
        this.iter.remove();
        for (int b = 0; b < this.priorities.length; b = (int)((byte)(b + 1))) {
            if (this.priorities[b] < 0) continue;
            int n = b;
            this.priorities[n] = this.priorities[n] - 1;
        }
    }

    public int size() {
        return this.list.size();
    }

    public void clear() {
        this.list.clear();
    }

    public void addMessageByPriority(MessageReference node) throws IOException {
        int priority = node.getMessage().getPriority();
        int index = this.priorities[priority];
        if (index > -1) {
            for (int i = priority; i >= 0; --i) {
                if (this.priorities[i] < 0) continue;
                int n = i;
                this.priorities[n] = this.priorities[n] + 1;
            }
            ++index;
        } else {
            index = 0;
            boolean hasHigherPriorityMessage = false;
            for (int i = priority; i < this.priorities.length; ++i) {
                if (this.priorities[i] < 0) continue;
                index = this.priorities[i] + 1;
                for (int x = priority; x >= 0; --x) {
                    this.priorities[priority] = index;
                    if (this.priorities[x] <= -1) continue;
                    int n = x;
                    this.priorities[n] = this.priorities[n] + 1;
                }
                hasHigherPriorityMessage = true;
                break;
            }
            if (!hasHigherPriorityMessage) {
                int n = priority;
                this.priorities[n] = this.priorities[n] + 1;
                for (int x = priority - 1; x >= 0; --x) {
                    if (this.priorities[x] <= -1) continue;
                    int n2 = x;
                    this.priorities[n2] = this.priorities[n2] + 1;
                }
            }
        }
        if (index > this.list.size()) {
            this.list.addLast(node);
        } else if (this.list.size() == 0) {
            this.list.add(node);
        } else {
            this.list.add(index, node);
        }
    }
}

