/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.util;

import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggingBrokerPlugin
extends BrokerPluginSupport {
    private Log log = LogFactory.getLog((Class)LoggingBrokerPlugin.class);
    private Log sendLog = LogFactory.getLog((String)(LoggingBrokerPlugin.class.getName() + ".Send"));
    private Log ackLog = LogFactory.getLog((String)(LoggingBrokerPlugin.class.getName() + ".Ack"));

    public void send(ConnectionContext context, Message messageSend) throws Exception {
        if (this.sendLog.isInfoEnabled()) {
            this.sendLog.info((Object)("Sending: " + messageSend));
        }
        super.send(context, messageSend);
    }

    public void acknowledge(ConnectionContext context, MessageAck ack) throws Exception {
        if (this.ackLog.isInfoEnabled()) {
            this.ackLog.info((Object)("Acknowledge: " + ack));
        }
        super.acknowledge(context, ack);
    }

    public Log getAckLog() {
        return this.ackLog;
    }

    public void setAckLog(Log ackLog) {
        this.ackLog = ackLog;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getSendLog() {
        return this.sendLog;
    }

    public void setSendLog(Log sendLog) {
        this.sendLog = sendLog;
    }
}

