/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network.jms;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.NamingException;
import org.apache.activemq.network.jms.InboundTopicBridge;
import org.apache.activemq.network.jms.JmsConnector;
import org.apache.activemq.network.jms.OutboundTopicBridge;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsTopicConnector
extends JmsConnector {
    private static final Log log = LogFactory.getLog((Class)JmsTopicConnector.class);
    private String outboundTopicConnectionFactoryName;
    private String localConnectionFactoryName;
    private TopicConnectionFactory outboundTopicConnectionFactory;
    private TopicConnectionFactory localTopicConnectionFactory;
    private TopicConnection outboundTopicConnection;
    private TopicConnection localTopicConnection;
    private InboundTopicBridge[] inboundTopicBridges;
    private OutboundTopicBridge[] outboundTopicBridges;

    public boolean init() {
        boolean result = super.init();
        if (result) {
            try {
                this.initializeForeignTopicConnection();
                this.initializeLocalTopicConnection();
                this.initializeInboundJmsMessageConvertor();
                this.initializeOutboundJmsMessageConvertor();
                this.initializeInboundTopicBridges();
                this.initializeOutboundTopicBridges();
            }
            catch (Exception e) {
                log.error((Object)"Failed to initialize the JMSConnector", (Throwable)e);
            }
        }
        return result;
    }

    public InboundTopicBridge[] getInboundTopicBridges() {
        return this.inboundTopicBridges;
    }

    public void setInboundTopicBridges(InboundTopicBridge[] inboundTopicBridges) {
        this.inboundTopicBridges = inboundTopicBridges;
    }

    public OutboundTopicBridge[] getOutboundTopicBridges() {
        return this.outboundTopicBridges;
    }

    public void setOutboundTopicBridges(OutboundTopicBridge[] outboundTopicBridges) {
        this.outboundTopicBridges = outboundTopicBridges;
    }

    public TopicConnectionFactory getLocalTopicConnectionFactory() {
        return this.localTopicConnectionFactory;
    }

    public void setLocalTopicConnectionFactory(TopicConnectionFactory localConnectionFactory) {
        this.localTopicConnectionFactory = localConnectionFactory;
    }

    public TopicConnectionFactory getOutboundTopicConnectionFactory() {
        return this.outboundTopicConnectionFactory;
    }

    public String getOutboundTopicConnectionFactoryName() {
        return this.outboundTopicConnectionFactoryName;
    }

    public void setOutboundTopicConnectionFactoryName(String foreignTopicConnectionFactoryName) {
        this.outboundTopicConnectionFactoryName = foreignTopicConnectionFactoryName;
    }

    public String getLocalConnectionFactoryName() {
        return this.localConnectionFactoryName;
    }

    public void setLocalConnectionFactoryName(String localConnectionFactoryName) {
        this.localConnectionFactoryName = localConnectionFactoryName;
    }

    public TopicConnection getLocalTopicConnection() {
        return this.localTopicConnection;
    }

    public void setLocalTopicConnection(TopicConnection localTopicConnection) {
        this.localTopicConnection = localTopicConnection;
    }

    public TopicConnection getOutboundTopicConnection() {
        return this.outboundTopicConnection;
    }

    public void setOutboundTopicConnection(TopicConnection foreignTopicConnection) {
        this.outboundTopicConnection = foreignTopicConnection;
    }

    public void setOutboundTopicConnectionFactory(TopicConnectionFactory foreignTopicConnectionFactory) {
        this.outboundTopicConnectionFactory = foreignTopicConnectionFactory;
    }

    public void restartProducerConnection() throws NamingException, JMSException {
        this.outboundTopicConnection = null;
        this.initializeForeignTopicConnection();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initializeForeignTopicConnection() throws NamingException, JMSException {
        if (this.outboundTopicConnection == null) {
            if (this.outboundTopicConnectionFactory == null) {
                if (this.outboundTopicConnectionFactoryName == null) throw new JMSException("Cannot create localConnection - no information");
                this.outboundTopicConnectionFactory = (TopicConnectionFactory)this.jndiOutboundTemplate.lookup(this.outboundTopicConnectionFactoryName, TopicConnectionFactory.class);
                this.outboundTopicConnection = this.outboundUsername != null ? this.outboundTopicConnectionFactory.createTopicConnection(this.outboundUsername, this.outboundPassword) : this.outboundTopicConnectionFactory.createTopicConnection();
            } else {
                this.outboundTopicConnection = this.outboundUsername != null ? this.outboundTopicConnectionFactory.createTopicConnection(this.outboundUsername, this.outboundPassword) : this.outboundTopicConnectionFactory.createTopicConnection();
            }
        }
        this.outboundTopicConnection.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initializeLocalTopicConnection() throws NamingException, JMSException {
        if (this.localTopicConnection == null) {
            if (this.localTopicConnectionFactory == null) {
                if (this.embeddedConnectionFactory == null) {
                    if (this.localConnectionFactoryName == null) throw new JMSException("Cannot create localConnection - no information");
                    this.localTopicConnectionFactory = (TopicConnectionFactory)this.jndiLocalTemplate.lookup(this.localConnectionFactoryName, TopicConnectionFactory.class);
                    this.localTopicConnection = this.localUsername != null ? this.localTopicConnectionFactory.createTopicConnection(this.localUsername, this.localPassword) : this.localTopicConnectionFactory.createTopicConnection();
                } else {
                    this.localTopicConnection = this.embeddedConnectionFactory.createTopicConnection();
                }
            } else {
                this.localTopicConnection = this.localUsername != null ? this.localTopicConnectionFactory.createTopicConnection(this.localUsername, this.localPassword) : this.localTopicConnectionFactory.createTopicConnection();
            }
        }
        this.localTopicConnection.start();
    }

    protected void initializeInboundJmsMessageConvertor() {
        this.inboundMessageConvertor.setConnection((Connection)this.localTopicConnection);
    }

    protected void initializeOutboundJmsMessageConvertor() {
        this.outboundMessageConvertor.setConnection((Connection)this.outboundTopicConnection);
    }

    protected void initializeInboundTopicBridges() throws JMSException {
        if (this.inboundTopicBridges != null) {
            TopicSession outboundSession = this.outboundTopicConnection.createTopicSession(false, 1);
            TopicSession localSession = this.localTopicConnection.createTopicSession(false, 1);
            for (int i = 0; i < this.inboundTopicBridges.length; ++i) {
                InboundTopicBridge bridge = this.inboundTopicBridges[i];
                String localTopicName = bridge.getLocalTopicName();
                Topic activemqTopic = this.createActiveMQTopic(localSession, localTopicName);
                String topicName = bridge.getInboundTopicName();
                Topic foreignTopic = this.createForeignTopic(outboundSession, topicName);
                bridge.setConsumerTopic(foreignTopic);
                bridge.setProducerTopic(activemqTopic);
                bridge.setProducerConnection(this.localTopicConnection);
                bridge.setConsumerConnection(this.outboundTopicConnection);
                if (bridge.getJmsMessageConvertor() == null) {
                    bridge.setJmsMessageConvertor(this.getInboundMessageConvertor());
                }
                bridge.setJmsConnector(this);
                this.addInboundBridge(bridge);
            }
            outboundSession.close();
            localSession.close();
        }
    }

    protected void initializeOutboundTopicBridges() throws JMSException {
        if (this.outboundTopicBridges != null) {
            TopicSession outboundSession = this.outboundTopicConnection.createTopicSession(false, 1);
            TopicSession localSession = this.localTopicConnection.createTopicSession(false, 1);
            for (int i = 0; i < this.outboundTopicBridges.length; ++i) {
                OutboundTopicBridge bridge = this.outboundTopicBridges[i];
                String localTopicName = bridge.getLocalTopicName();
                Topic activemqTopic = this.createActiveMQTopic(localSession, localTopicName);
                String topicName = bridge.getOutboundTopicName();
                Topic foreignTopic = this.createForeignTopic(outboundSession, topicName);
                bridge.setConsumerTopic(activemqTopic);
                bridge.setProducerTopic(foreignTopic);
                bridge.setProducerConnection(this.outboundTopicConnection);
                bridge.setConsumerConnection(this.localTopicConnection);
                if (bridge.getJmsMessageConvertor() == null) {
                    bridge.setJmsMessageConvertor(this.getOutboundMessageConvertor());
                }
                bridge.setJmsConnector(this);
                this.addOutboundBridge(bridge);
            }
            outboundSession.close();
            localSession.close();
        }
    }

    protected Destination createReplyToBridge(Destination destination, Connection replyToProducerConnection, Connection replyToConsumerConnection) {
        Topic replyToProducerTopic = (Topic)destination;
        boolean isInbound = replyToProducerConnection.equals(this.localTopicConnection);
        if (isInbound) {
            InboundTopicBridge bridge = (InboundTopicBridge)this.replyToBridges.get(replyToProducerTopic);
            if (bridge == null) {
                bridge = new InboundTopicBridge(){

                    protected Destination processReplyToDestination(Destination destination) {
                        return null;
                    }
                };
                try {
                    TopicSession replyToConsumerSession = ((TopicConnection)replyToConsumerConnection).createTopicSession(false, 1);
                    TemporaryTopic replyToConsumerTopic = replyToConsumerSession.createTemporaryTopic();
                    replyToConsumerSession.close();
                    bridge.setConsumerTopic((Topic)replyToConsumerTopic);
                    bridge.setProducerTopic(replyToProducerTopic);
                    bridge.setProducerConnection((TopicConnection)replyToProducerConnection);
                    bridge.setConsumerConnection((TopicConnection)replyToConsumerConnection);
                    bridge.setDoHandleReplyTo(false);
                    if (bridge.getJmsMessageConvertor() == null) {
                        bridge.setJmsMessageConvertor(this.getInboundMessageConvertor());
                    }
                    bridge.setJmsConnector(this);
                    bridge.start();
                    log.info((Object)("Created replyTo bridge for " + replyToProducerTopic));
                }
                catch (Exception e) {
                    log.error((Object)("Failed to create replyTo bridge for topic: " + replyToProducerTopic), (Throwable)e);
                    return null;
                }
                this.replyToBridges.put(replyToProducerTopic, bridge);
            }
            return bridge.getConsumerTopic();
        }
        OutboundTopicBridge bridge = (OutboundTopicBridge)this.replyToBridges.get(replyToProducerTopic);
        if (bridge == null) {
            bridge = new OutboundTopicBridge(){

                protected Destination processReplyToDestination(Destination destination) {
                    return null;
                }
            };
            try {
                TopicSession replyToConsumerSession = ((TopicConnection)replyToConsumerConnection).createTopicSession(false, 1);
                TemporaryTopic replyToConsumerTopic = replyToConsumerSession.createTemporaryTopic();
                replyToConsumerSession.close();
                bridge.setConsumerTopic((Topic)replyToConsumerTopic);
                bridge.setProducerTopic(replyToProducerTopic);
                bridge.setProducerConnection((TopicConnection)replyToProducerConnection);
                bridge.setConsumerConnection((TopicConnection)replyToConsumerConnection);
                bridge.setDoHandleReplyTo(false);
                if (bridge.getJmsMessageConvertor() == null) {
                    bridge.setJmsMessageConvertor(this.getOutboundMessageConvertor());
                }
                bridge.setJmsConnector(this);
                bridge.start();
                log.info((Object)("Created replyTo bridge for " + replyToProducerTopic));
            }
            catch (Exception e) {
                log.error((Object)("Failed to create replyTo bridge for topic: " + replyToProducerTopic), (Throwable)e);
                return null;
            }
            this.replyToBridges.put(replyToProducerTopic, bridge);
        }
        return bridge.getConsumerTopic();
    }

    protected Topic createActiveMQTopic(TopicSession session, String topicName) throws JMSException {
        return session.createTopic(topicName);
    }

    protected Topic createForeignTopic(TopicSession session, String topicName) throws JMSException {
        Topic result = null;
        try {
            result = session.createTopic(topicName);
        }
        catch (JMSException e) {
            try {
                result = (Topic)this.jndiOutboundTemplate.lookup(topicName, Topic.class);
            }
            catch (NamingException e1) {
                String errStr = "Failed to look-up Topic for name: " + topicName;
                log.error((Object)errStr, (Throwable)e);
                JMSException jmsEx = new JMSException(errStr);
                jmsEx.setLinkedException((Exception)e1);
                throw jmsEx;
            }
        }
        return result;
    }
}

