/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.pool.SessionKey;
import org.apache.activemq.pool.SessionPool;
import org.apache.activemq.transport.TransportListener;
import org.apache.commons.pool.ObjectPoolFactory;

public class ConnectionPool {
    private ActiveMQConnection connection;
    private Map cache;
    private AtomicBoolean started = new AtomicBoolean(false);
    private int referenceCount;
    private ObjectPoolFactory poolFactory;
    private long lastUsed;
    private boolean hasFailed;
    private int idleTimeout = 30000;

    public ConnectionPool(ActiveMQConnection connection, ObjectPoolFactory poolFactory) {
        this(connection, new HashMap(), poolFactory);
        connection.addTransportListener(new TransportListener(){

            public void onCommand(Object command) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onException(IOException error) {
                ConnectionPool connectionPool = ConnectionPool.this;
                synchronized (connectionPool) {
                    ConnectionPool.this.hasFailed = true;
                }
            }

            public void transportInterupted() {
            }

            public void transportResumed() {
            }
        });
    }

    public ConnectionPool(ActiveMQConnection connection, Map cache, ObjectPoolFactory poolFactory) {
        this.connection = connection;
        this.cache = cache;
        this.poolFactory = poolFactory;
    }

    public void start() throws JMSException {
        if (this.started.compareAndSet(false, true)) {
            this.connection.start();
        }
    }

    public synchronized ActiveMQConnection getConnection() {
        return this.connection;
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        SessionKey key = new SessionKey(transacted, ackMode);
        SessionPool pool = (SessionPool)this.cache.get(key);
        if (pool == null) {
            pool = new SessionPool(this, key, this.poolFactory.createPool());
            this.cache.put(key, pool);
        }
        return pool.borrowSession();
    }

    public synchronized void close() {
        if (this.connection != null) {
            Iterator i = this.cache.values().iterator();
            while (i.hasNext()) {
                SessionPool pool = (SessionPool)i.next();
                i.remove();
                try {
                    pool.close();
                }
                catch (Exception exception) {}
            }
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    public synchronized void incrementReferenceCount() {
        ++this.referenceCount;
    }

    public synchronized void decrementReferenceCount() {
        --this.referenceCount;
        if (this.referenceCount == 0) {
            this.lastUsed = System.currentTimeMillis();
            this.expiredCheck();
        }
    }

    public synchronized boolean expiredCheck() {
        if (this.connection == null) {
            return true;
        }
        if (this.hasFailed || this.idleTimeout > 0 && System.currentTimeMillis() > this.lastUsed + (long)this.idleTimeout) {
            if (this.referenceCount == 0) {
                this.close();
            }
            return true;
        }
        return false;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }
}

