/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.state;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.TransactionId;

public class TransactionState {
    final TransactionId id;
    public final ArrayList commands = new ArrayList();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private boolean prepared;
    private int preparedResult;

    public TransactionState(TransactionId id) {
        this.id = id;
    }

    public String toString() {
        return this.id.toString();
    }

    public void addCommand(Command operation) {
        this.checkShutdown();
        this.commands.add(operation);
    }

    public List getCommands() {
        return this.commands;
    }

    private void checkShutdown() {
        if (this.shutdown.get()) {
            throw new IllegalStateException("Disposed");
        }
    }

    public void shutdown() {
        this.shutdown.set(false);
    }

    public TransactionId getId() {
        return this.id;
    }

    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public void setPreparedResult(int preparedResult) {
        this.preparedResult = preparedResult;
    }

    public int getPreparedResult() {
        return this.preparedResult;
    }
}

