/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.jdbc.JDBCAdapter;
import org.apache.activemq.store.jdbc.JDBCMessageRecoveryListener;
import org.apache.activemq.store.jdbc.JDBCMessageStore;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.TransactionContext;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.wireformat.WireFormat;

public class JDBCTopicMessageStore
extends JDBCMessageStore
implements TopicMessageStore {
    public JDBCTopicMessageStore(JDBCPersistenceAdapter persistenceAdapter, JDBCAdapter adapter, WireFormat wireFormat, ActiveMQTopic topic) {
        super(persistenceAdapter, adapter, wireFormat, topic);
    }

    public void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId) throws IOException {
        long seq = messageId.getBrokerSequenceId();
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        try {
            this.adapter.doSetLastAck(c, this.destination, clientId, subscriptionName, seq);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to store acknowledgment for: " + clientId + " on message " + messageId + " in container: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public void recoverSubscription(String clientId, String subscriptionName, final MessageRecoveryListener listener) throws Exception {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            this.adapter.doRecoverSubscription(c, this.destination, clientId, subscriptionName, new JDBCMessageRecoveryListener(){

                public void recoverMessage(long sequenceId, byte[] data) throws Exception {
                    Message msg = (Message)JDBCTopicMessageStore.this.wireFormat.unmarshal(new ByteSequence(data));
                    msg.getMessageId().setBrokerSequenceId(sequenceId);
                    listener.recoverMessage(msg);
                }

                public void recoverMessageReference(String reference) throws Exception {
                    listener.recoverMessageReference(reference);
                }

                public void finished() {
                    listener.finished();
                }
            });
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to recover subscription: " + clientId + ". Reason: " + e, e);
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverNextMessages(String clientId, String subscriptionName, MessageId lastMessageId, int maxReturned, final MessageRecoveryListener listener) throws Exception {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            long lastSequence = lastMessageId != null ? lastMessageId.getBrokerSequenceId() : -1L;
            this.adapter.doRecoverNextMessages(c, this.destination, clientId, subscriptionName, lastSequence, maxReturned, new JDBCMessageRecoveryListener(){

                public void recoverMessage(long sequenceId, byte[] data) throws Exception {
                    Message msg = (Message)JDBCTopicMessageStore.this.wireFormat.unmarshal(new ByteSequence(data));
                    msg.getMessageId().setBrokerSequenceId(sequenceId);
                    listener.recoverMessage(msg);
                }

                public void recoverMessageReference(String reference) throws Exception {
                    listener.recoverMessageReference(reference);
                }

                public void finished() {
                    listener.finished();
                }
            });
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
        }
        finally {
            c.close();
        }
    }

    public void resetBatching(String clientId, String subscriptionName, MessageId id) {
    }

    public void addSubsciption(String clientId, String subscriptionName, String selector, boolean retroactive) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            c = this.persistenceAdapter.getTransactionContext();
            this.adapter.doSetSubscriberEntry(c, this.destination, clientId, subscriptionName, selector, retroactive);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to lookup subscription for info: " + clientId + ". Reason: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            SubscriptionInfo subscriptionInfo = this.adapter.doGetSubscriberEntry(c, this.destination, clientId, subscriptionName);
            return subscriptionInfo;
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to lookup subscription for: " + clientId + ". Reason: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public void deleteSubscription(String clientId, String subscriptionName) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            this.adapter.doDeleteSubscription(c, this.destination, clientId, subscriptionName);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to remove subscription for: " + clientId + ". Reason: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public SubscriptionInfo[] getAllSubscriptions() throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            SubscriptionInfo[] subscriptionInfoArray = this.adapter.doGetAllSubscriptions(c, this.destination);
            return subscriptionInfoArray;
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to lookup subscriptions. Reason: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public MessageId getNextMessageIdToDeliver(String clientId, String subscriptionName, MessageId id) throws Exception {
        final MessageId result = new MessageId();
        final AtomicBoolean initalized = new AtomicBoolean();
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            long sequence = id != null ? id.getBrokerSequenceId() : -1L;
            this.adapter.doGetNextDurableSubscriberMessageIdStatement(c, this.destination, clientId, subscriptionName, sequence, new JDBCMessageRecoveryListener(){

                public void recoverMessage(long sequenceId, byte[] data) throws Exception {
                    Message msg = (Message)JDBCTopicMessageStore.this.wireFormat.unmarshal(new ByteSequence(data));
                    msg.getMessageId().setBrokerSequenceId(sequenceId);
                    result.setBrokerSequenceId(msg.getMessageId().getBrokerSequenceId());
                    initalized.set(true);
                }

                public void recoverMessageReference(String reference) throws Exception {
                    result.setValue(reference);
                    initalized.set(true);
                }

                public void finished() {
                }
            });
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to get next MessageId to deliver: " + clientId + ". Reason: " + e, e);
        }
        finally {
            c.close();
        }
        return initalized.get() ? result : null;
    }

    public MessageId getPreviousMessageIdToDeliver(String clientId, String subscriptionName, MessageId id) throws Exception {
        final MessageId result = new MessageId();
        final AtomicBoolean initalized = new AtomicBoolean();
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            long sequence = id != null ? id.getBrokerSequenceId() : -1L;
            this.adapter.doGetPrevDurableSubscriberMessageIdStatement(c, this.destination, clientId, subscriptionName, sequence, new JDBCMessageRecoveryListener(){

                public void recoverMessage(long sequenceId, byte[] data) throws Exception {
                    Message msg = (Message)JDBCTopicMessageStore.this.wireFormat.unmarshal(new ByteSequence(data));
                    msg.getMessageId().setBrokerSequenceId(sequenceId);
                    result.setProducerId(msg.getMessageId().getProducerId());
                    result.setProducerSequenceId(msg.getMessageId().getProducerSequenceId());
                    result.setBrokerSequenceId(msg.getMessageId().getBrokerSequenceId());
                    initalized.set(true);
                }

                public void recoverMessageReference(String reference) throws Exception {
                    result.setValue(reference);
                    initalized.set(true);
                }

                public void finished() {
                }
            });
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to get next MessageId to deliver: " + clientId + ". Reason: " + e, e);
        }
        finally {
            c.close();
        }
        return initalized.get() ? result : null;
    }

    public int getMessageCount(String clientId, String subscriberName) throws IOException {
        int result = 0;
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            result = this.adapter.doGetDurableSubscriberMessageCount(c, this.destination, clientId, subscriberName);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to get Message Count: " + clientId + ". Reason: " + e, e);
        }
        finally {
            c.close();
        }
        return result;
    }
}

