/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;

public class CommandMarshaller
implements Marshaller {
    private WireFormat wireFormat;

    public CommandMarshaller(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public void writePayload(Object object, DataOutput dataOut) throws IOException {
        ByteSequence packet = this.wireFormat.marshal(object);
        dataOut.writeInt(packet.length);
        dataOut.write(packet.data, packet.offset, packet.length);
    }

    public Object readPayload(DataInput dataIn) throws IOException {
        int size = dataIn.readInt();
        byte[] data = new byte[size];
        dataIn.readFully(data);
        return this.wireFormat.unmarshal(new ByteSequence(data));
    }
}

