/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix;

import java.io.File;
import java.util.ArrayList;
import org.apache.servicemix.jbi.container.SpringJBIContainer;
import org.apache.xbean.server.repository.FileSystemRepository;
import org.apache.xbean.server.repository.Repository;
import org.apache.xbean.server.spring.configuration.ClassLoaderXmlPreprocessor;
import org.apache.xbean.spring.context.ClassPathXmlApplicationContext;
import org.apache.xbean.spring.context.FileSystemXmlApplicationContext;
import org.springframework.beans.factory.DisposableBean;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            String version = "";
            Package p = Package.getPackage("org.apache.servicemix");
            if (p != null) {
                version = ": " + p.getImplementationVersion();
            }
            System.out.println("Starting Apache ServiceMix ESB" + version);
            System.out.println();
            ClassPathXmlApplicationContext context = null;
            if (args.length <= 0) {
                System.out.println("Loading Apache ServiceMix from servicemix.xml on the CLASSPATH");
                context = new ClassPathXmlApplicationContext("servicemix.xml");
            } else {
                String file = args[0];
                if (file.equals("-?") || file.equals("?") || file.equals("--help") || file.equals("-h")) {
                    System.out.println("Usage: Main [-v1] [xmlConfigFile]");
                    System.out.println("If an XML config file is not specified then servicemix.xml is used from the CLASSPATH");
                    return;
                }
                ArrayList<ClassLoaderXmlPreprocessor> processors = new ArrayList<ClassLoaderXmlPreprocessor>();
                processors.add(new ClassLoaderXmlPreprocessor((Repository)new FileSystemRepository(new File("."))));
                System.out.println("Loading Apache ServiceMix from file: " + file);
                context = new FileSystemXmlApplicationContext(file, processors);
            }
            SpringJBIContainer container = (SpringJBIContainer)context.getBean("jbi");
            Object lock = new Object();
            container.setShutdownLock(lock);
            Object object = lock;
            synchronized (object) {
                lock.wait();
            }
            if (context instanceof DisposableBean) {
                ((DisposableBean)context).destroy();
            }
        }
        catch (Exception e) {
            System.out.println("Caught: " + e);
            e.printStackTrace();
        }
    }
}

