/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.client;

import java.util.Map;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.servicemix.client.DefaultNamespaceContext;

public class XPathHelper {
    private Source content;
    private XPathFactory xPathFactory;
    private XPath xPath;

    public XPathHelper() {
    }

    public XPathHelper(NormalizedMessage message) {
        this.setMessage(message);
    }

    public XPathHelper(Source content) {
        this.setContent(content);
    }

    public XPathHelper(NormalizedMessage message, Map namespaces) {
        this(message);
        this.setNamespaces(namespaces);
    }

    public XPathHelper(NormalizedMessage message, NamespaceContext namespaces) {
        this(message);
        this.setNamespaceContext(namespaces);
    }

    public Object evaluate(String expression, QName arg2) throws XPathExpressionException {
        return this.getXPath().evaluate(expression, this.getItem(), arg2);
    }

    public String evaluate(String expression) throws XPathExpressionException {
        return this.getXPath().evaluate(expression, this.getItem());
    }

    public void reset() {
        if (this.xPath != null) {
            this.getXPath().reset();
        }
    }

    public void setMessage(NormalizedMessage message) {
        this.setContent(message.getContent());
    }

    public void setContent(Source content) {
        this.content = content;
    }

    public NamespaceContext getNamespaceContext() {
        return this.getXPath().getNamespaceContext();
    }

    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.getXPath().getXPathFunctionResolver();
    }

    public XPathVariableResolver getXPathVariableResolver() {
        return this.getXPath().getXPathVariableResolver();
    }

    public void setNamespaceContext(NamespaceContext context) {
        this.getXPath().setNamespaceContext(context);
    }

    public void setXPathFunctionResolver(XPathFunctionResolver resolver) {
        this.getXPath().setXPathFunctionResolver(resolver);
    }

    public void setXPathVariableResolver(XPathVariableResolver resolver) {
        this.getXPath().setXPathVariableResolver(resolver);
    }

    public XPathFactory getXPathFactory() {
        if (this.xPathFactory == null) {
            this.xPathFactory = XPathFactory.newInstance();
        }
        return this.xPathFactory;
    }

    public void setXPathFactory(XPathFactory factory) {
        this.xPathFactory = factory;
    }

    public Source getContent() {
        return this.content;
    }

    public XPath getXPath() {
        if (this.xPath == null) {
            this.xPath = this.getXPathFactory().newXPath();
        }
        return this.xPath;
    }

    public void setNamespaces(Map namespaces) {
        this.setNamespaceContext(new DefaultNamespaceContext(this.getNamespaceContext(), namespaces));
    }

    protected Object getItem() {
        return this.content;
    }
}

