/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.components.util.MessageHelper;
import org.apache.servicemix.jbi.FaultException;
import org.apache.servicemix.jbi.NotInitialisedYetException;
import org.apache.servicemix.jbi.management.BaseLifeCycle;

public abstract class PojoSupport
extends BaseLifeCycle
implements ComponentLifeCycle {
    private ComponentContext context;
    private ObjectName extensionMBeanName;
    private QName service;
    private String endpoint;
    private MessageExchangeFactory exchangeFactory;
    private String description = "POJO Component";
    private ServiceEndpoint serviceEndpoint;
    private DeliveryChannel channel;
    protected Log logger = LogFactory.getLog(this.getClass());

    protected PojoSupport() {
    }

    protected PojoSupport(QName service, String endpoint) {
        this.service = service;
        this.endpoint = endpoint;
    }

    public String getDescription() {
        return this.description;
    }

    public void init(ComponentContext cc) throws JBIException {
        this.context = cc;
        this.channel = this.context.getDeliveryChannel();
        this.init();
        if (this.service != null && this.endpoint != null) {
            this.serviceEndpoint = this.context.activateEndpoint(this.service, this.endpoint);
        }
    }

    public void shutDown() throws JBIException {
        if (this.serviceEndpoint != null) {
            this.context.deactivateEndpoint(this.serviceEndpoint);
        }
        this.exchangeFactory = null;
        super.shutDown();
    }

    public Object getBody(NormalizedMessage message) throws MessagingException {
        return MessageHelper.getBody(message);
    }

    public void setBody(NormalizedMessage message, Object body) throws MessagingException {
        MessageHelper.setBody(message, body);
    }

    public ObjectName getExtensionMBeanName() {
        return this.extensionMBeanName;
    }

    public void setExtensionMBeanName(ObjectName extensionMBeanName) {
        this.extensionMBeanName = extensionMBeanName;
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public QName getService() {
        return this.service;
    }

    public void setService(QName service) {
        this.service = service;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public MessageExchangeFactory getExchangeFactory() throws MessagingException {
        if (this.exchangeFactory == null && this.context != null) {
            this.exchangeFactory = this.getDeliveryChannel().createExchangeFactory();
        }
        return this.exchangeFactory;
    }

    public DeliveryChannel getDeliveryChannel() throws MessagingException {
        if (this.channel == null) {
            throw new NotInitialisedYetException();
        }
        return this.channel;
    }

    protected void init() throws JBIException {
        super.init();
    }

    public void done(MessageExchange exchange) throws MessagingException {
        exchange.setStatus(ExchangeStatus.DONE);
        this.getDeliveryChannel().send(exchange);
    }

    public void send(MessageExchange exchange) throws MessagingException {
        this.getDeliveryChannel().send(exchange);
    }

    public boolean sendSync(MessageExchange exchange) throws MessagingException {
        return this.getDeliveryChannel().sendSync(exchange);
    }

    public boolean sendSync(MessageExchange exchange, long timeMillis) throws MessagingException {
        return this.getDeliveryChannel().sendSync(exchange, timeMillis);
    }

    public void answer(MessageExchange exchange, NormalizedMessage answer) throws MessagingException {
        exchange.setMessage(answer, "out");
        this.getDeliveryChannel().send(exchange);
    }

    public void fail(MessageExchange exchange, Fault fault) throws MessagingException {
        if (exchange instanceof InOnly || fault == null) {
            exchange.setError((Exception)((Object)new FaultException("Fault occured for in-only exchange", exchange, fault)));
        } else {
            exchange.setFault(fault);
        }
        this.getDeliveryChannel().send(exchange);
    }

    public void fail(MessageExchange exchange, Exception error) throws MessagingException {
        if (exchange instanceof InOnly || !(error instanceof FaultException)) {
            exchange.setError(error);
        } else {
            FaultException faultException = (FaultException)((Object)error);
            exchange.setFault(faultException.getFault());
        }
        this.getDeliveryChannel().send(exchange);
    }

    protected boolean isInAndOut(MessageExchange exchange) {
        return exchange instanceof InOut || exchange instanceof InOptionalOut;
    }
}

