/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.component.Bootstrap;
import javax.jbi.component.InstallationContext;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.NotInitialisedYetException;
import org.apache.servicemix.jbi.container.ActivationSpec;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.DocumentFragment;

public class SpringBootstrap
implements Bootstrap,
ApplicationContextAware {
    private InstallationContext installContext;
    private ObjectName extensionMBeanName;
    private ApplicationContext applicationContext;
    private static Log log = LogFactory.getLog(SpringBootstrap.class);

    public void init(InstallationContext installContext) throws JBIException {
        this.installContext = installContext;
    }

    public void cleanUp() throws JBIException {
    }

    public ObjectName getExtensionMBeanName() {
        return this.extensionMBeanName;
    }

    public void onInstall() throws JBIException {
        if (this.installContext == null) {
            throw new NotInitialisedYetException();
        }
        DocumentFragment fragment = this.installContext.getInstallationDescriptorExtension();
        if (fragment != null) {
            log.debug((Object)"Installation Descriptor Extension Found");
        } else {
            log.debug((Object)"Installation Descriptor Extension Not Found !");
        }
        Map map = this.applicationContext.getBeansOfType(ActivationSpec.class, false, false);
        for (ActivationSpec spec : map.values()) {
            log.debug((Object)("Registering " + spec.getComponentName()));
        }
    }

    public void onUninstall() throws JBIException {
    }

    public InstallationContext getInstallContext() {
        return this.installContext;
    }

    public void setApplicationContext(ApplicationContext appCtx) throws BeansException {
        this.applicationContext = appCtx;
    }
}

