/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.expression;

import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import org.apache.servicemix.expression.Expression;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlSaxHandler;

public class XMLBeansXPathExpression
implements Expression {
    private String xpath;
    private XmlOptions options = new XmlOptions();
    private SourceTransformer transformer = new SourceTransformer();

    public XMLBeansXPathExpression(String xpath) {
        this.xpath = xpath;
    }

    public Object evaluate(MessageExchange exchange, NormalizedMessage message) throws MessagingException {
        try {
            XmlSaxHandler handler = XmlObject.Factory.newXmlSaxHandler();
            SAXResult result = new SAXResult(handler.getContentHandler());
            this.transformer.toResult(message.getContent(), result);
            XmlObject object = handler.getObject();
            return this.evaluateXPath(object, this.xpath, this.options);
        }
        catch (TransformerException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (XmlException e) {
            throw new MessagingException((Throwable)e);
        }
    }

    protected Object evaluateXPath(XmlObject object, String xpath, XmlOptions options) {
        XmlObject[] xmlObjects = object.selectPath(this.xpath, this.options);
        if (xmlObjects.length == 1) {
            return xmlObjects[0];
        }
        return xmlObjects;
    }
}

