/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import java.io.Serializable;
import javax.jbi.JBIException;
import javax.management.JMException;
import javax.management.MBeanOperationInfo;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.client.DefaultServiceMixClient;
import org.apache.servicemix.client.ServiceMixClient;
import org.apache.servicemix.jbi.framework.ClientFactoryMBean;
import org.apache.servicemix.jbi.management.BaseSystemService;
import org.apache.servicemix.jbi.management.OperationInfoHelper;

public class ClientFactory
extends BaseSystemService
implements ClientFactoryMBean,
Serializable {
    private static final Log logger = LogFactory.getLog(ClientFactory.class);
    private String jndiName = "java:comp/env/jbi/ClientFactory";

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public ServiceMixClient createClient() throws JBIException {
        return new DefaultServiceMixClient(this.getContainer());
    }

    protected Class getServiceMBean() {
        return ClientFactoryMBean.class;
    }

    public String getDescription() {
        return "Client Factory Service";
    }

    public MBeanOperationInfo[] getOperationInfos() throws JMException {
        OperationInfoHelper helper = new OperationInfoHelper();
        helper.addOperation(this.getObjectToManage(), "createClient", 0, "create a new client");
        return OperationInfoHelper.join(super.getOperationInfos(), helper.getOperationInfos());
    }

    public void start() throws JBIException {
        block2: {
            try {
                this.getContainer().getNamingContext().bind(this.jndiName, (Object)this);
                super.start();
            }
            catch (NamingException e) {
                logger.warn((Object)("Cound not start ClientFactory: " + e));
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)"Could not start ClientFactory", (Throwable)e);
            }
        }
    }

    public void stop() throws JBIException {
        block2: {
            try {
                super.stop();
                this.getContainer().getNamingContext().unbind(this.jndiName);
            }
            catch (NamingException e) {
                logger.warn((Object)("Cound not stop ClientFactory: " + e));
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)"Could not stop ClientFactory", (Throwable)e);
            }
        }
    }
}

