/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jbi.JBIException;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;
import javax.jbi.management.DeploymentServiceMBean;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.container.EnvironmentContext;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.container.ServiceAssemblyEnvironment;
import org.apache.servicemix.jbi.deployment.Descriptor;
import org.apache.servicemix.jbi.deployment.DescriptorFactory;
import org.apache.servicemix.jbi.deployment.ServiceAssembly;
import org.apache.servicemix.jbi.deployment.ServiceUnit;
import org.apache.servicemix.jbi.framework.AutoDeploymentService;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.framework.ManagementSupport;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.framework.ServiceAssemblyLifeCycle;
import org.apache.servicemix.jbi.framework.ServiceUnitLifeCycle;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.BaseSystemService;
import org.apache.servicemix.jbi.management.OperationInfoHelper;
import org.apache.servicemix.jbi.management.ParameterHelper;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.apache.servicemix.jbi.util.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentService
extends BaseSystemService
implements DeploymentServiceMBean {
    private static final Log log = LogFactory.getLog(DeploymentService.class);
    private EnvironmentContext environmentContext;
    private Registry registry;

    @Override
    public void init(JBIContainer container) throws JBIException {
        this.environmentContext = container.getEnvironmentContext();
        this.registry = container.getRegistry();
        super.init(container);
        this.buildState();
    }

    @Override
    protected Class<DeploymentServiceMBean> getServiceMBean() {
        return DeploymentServiceMBean.class;
    }

    @Override
    public void start() throws JBIException {
        super.start();
        String[] sas = this.registry.getDeployedServiceAssemblies();
        for (int i = 0; i < sas.length; ++i) {
            try {
                ServiceAssemblyLifeCycle sa = this.registry.getServiceAssembly(sas[i]);
                sa.restore();
                continue;
            }
            catch (Exception e) {
                log.error((Object)("Unable to restore state for service assembly " + sas[i]), (Throwable)e);
            }
        }
    }

    @Override
    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "deployedServiceAssemblies", "list of deployed SAs");
        return AttributeInfoHelper.join(super.getAttributeInfos(), helper.getAttributeInfos());
    }

    @Override
    public MBeanOperationInfo[] getOperationInfos() throws JMException {
        OperationInfoHelper helper = new OperationInfoHelper();
        ParameterHelper ph = helper.addOperation(this.getObjectToManage(), "deploy", 1, "deploy An SA");
        ph.setDescription(0, "saZipURL", "location of SA zip file");
        ph = helper.addOperation(this.getObjectToManage(), "undeploy", 1, "undeploy An SA");
        ph.setDescription(0, "saName", "SA name");
        ph = helper.addOperation(this.getObjectToManage(), "getDeployedServiceUnitList", 1, "list of SU's currently deployed");
        ph.setDescription(0, "componentName", "Component name");
        ph = helper.addOperation(this.getObjectToManage(), "getServiceAssemblyDescriptor", 1, "Get descriptor for a SA");
        ph.setDescription(0, "saName", "SA name");
        ph = helper.addOperation(this.getObjectToManage(), "getDeployedServiceAssembliesForComponent", 1, "list of SA's for a Component");
        ph.setDescription(0, "componentName", "Component name");
        ph = helper.addOperation(this.getObjectToManage(), "getComponentsForDeployedServiceAssembly", 1, "list of Components  for a SA");
        ph.setDescription(0, "saName", "SA name");
        ph = helper.addOperation(this.getObjectToManage(), "isDeployedServiceUnit", 2, "is SU deployed at a Component ?");
        ph.setDescription(0, "componentName", "Component name");
        ph.setDescription(1, "suName", "SU name");
        ph = helper.addOperation(this.getObjectToManage(), "canDeployToComponent", 1, "Can a SU be deployed to a Component?");
        ph.setDescription(0, "componentName", "Component name");
        ph = helper.addOperation(this.getObjectToManage(), "start", 1, "start an SA");
        ph.setDescription(0, "saName", "SA name");
        ph = helper.addOperation(this.getObjectToManage(), "stop", 1, "stop an SA");
        ph.setDescription(0, "saName", "SA name");
        ph = helper.addOperation(this.getObjectToManage(), "shutDown", 1, "shutDown an SA");
        ph.setDescription(0, "saName", "SA name");
        ph = helper.addOperation(this.getObjectToManage(), "getState", 1, "Running state of an SA");
        ph.setDescription(0, "saName", "SA name");
        return OperationInfoHelper.join(super.getOperationInfos(), helper.getOperationInfos());
    }

    @Override
    public String getDescription() {
        return "Allows admin tools to manage service deployments";
    }

    public String deploy(String saZipURL) throws Exception {
        try {
            if (saZipURL == null) {
                throw ManagementSupport.failure("deploy", "saZipURL must not be null");
            }
            File tmpDir = null;
            try {
                tmpDir = AutoDeploymentService.unpackLocation(this.environmentContext.getTmpDir(), saZipURL);
            }
            catch (Exception e) {
                throw ManagementSupport.failure("deploy", "Unable to unpack archive: " + saZipURL, e);
            }
            if (tmpDir == null) {
                throw ManagementSupport.failure("deploy", "Unable to find jbi descriptor: " + saZipURL);
            }
            Descriptor root = null;
            try {
                root = DescriptorFactory.buildDescriptor(tmpDir);
            }
            catch (Exception e) {
                throw ManagementSupport.failure("deploy", "Unable to build jbi descriptor: " + saZipURL, e);
            }
            if (root == null) {
                throw ManagementSupport.failure("deploy", "Unable to find jbi descriptor: " + saZipURL);
            }
            ServiceAssembly sa = root.getServiceAssembly();
            if (sa == null) {
                throw ManagementSupport.failure("deploy", "JBI descriptor is not an assembly descriptor: " + saZipURL);
            }
            return this.deployServiceAssembly(tmpDir, sa);
        }
        catch (Exception e) {
            log.error((Object)"Error deploying service assembly", (Throwable)e);
            throw e;
        }
    }

    public String undeploy(String saName) throws Exception {
        if (saName == null) {
            throw ManagementSupport.failure("undeploy", "SA name must not be null");
        }
        ServiceAssemblyLifeCycle sa = this.registry.getServiceAssembly(saName);
        if (sa == null) {
            throw ManagementSupport.failure("undeploy", "SA has not been deployed: " + saName);
        }
        String state = sa.getCurrentState();
        if (!"Shutdown".equals(state)) {
            throw ManagementSupport.failure("undeploy", "SA must be shut down: " + saName);
        }
        try {
            try {
                sa.shutDown();
            }
            catch (Exception e) {
                // empty catch block
            }
            String result = null;
            String assemblyName = sa.getName();
            this.registry.unregisterServiceAssembly(assemblyName);
            ServiceUnitLifeCycle[] sus = sa.getDeployedSUs();
            if (sus != null) {
                for (int i = 0; i < sus.length; ++i) {
                    this.undeployServiceUnit(sus[i]);
                }
            }
            FileUtil.deleteFile(sa.getEnvironment().getRootDir());
            return result;
        }
        catch (Exception e) {
            log.info((Object)"Unable to undeploy assembly", (Throwable)e);
            throw e;
        }
    }

    public String[] getDeployedServiceUnitList(String componentName) throws Exception {
        try {
            ServiceUnitLifeCycle[] sus = this.registry.getDeployedServiceUnits(componentName);
            String[] names = new String[sus.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = sus[i].getName();
            }
            return names;
        }
        catch (Exception e) {
            log.info((Object)"Unable to get deployed service unit list", (Throwable)e);
            throw e;
        }
    }

    public String[] getDeployedServiceAssemblies() throws Exception {
        try {
            return this.registry.getDeployedServiceAssemblies();
        }
        catch (Exception e) {
            log.info((Object)"Unable to get deployed service assemblies", (Throwable)e);
            throw e;
        }
    }

    public String getServiceAssemblyDescriptor(String saName) throws Exception {
        ServiceAssemblyLifeCycle sa = this.registry.getServiceAssembly(saName);
        if (sa != null) {
            return sa.getDescriptor();
        }
        return null;
    }

    public String[] getDeployedServiceAssembliesForComponent(String componentName) throws Exception {
        try {
            return this.registry.getDeployedServiceAssembliesForComponent(componentName);
        }
        catch (Exception e) {
            log.info((Object)"Error in getDeployedServiceAssembliesForComponent", (Throwable)e);
            throw e;
        }
    }

    public String[] getComponentsForDeployedServiceAssembly(String saName) throws Exception {
        try {
            return this.registry.getComponentsForDeployedServiceAssembly(saName);
        }
        catch (Exception e) {
            log.info((Object)"Error in getComponentsForDeployedServiceAssembly", (Throwable)e);
            throw e;
        }
    }

    public boolean isDeployedServiceUnit(String componentName, String suName) throws Exception {
        try {
            return this.registry.isSADeployedServiceUnit(componentName, suName);
        }
        catch (Exception e) {
            log.info((Object)"Error in isSADeployedServiceUnit", (Throwable)e);
            throw e;
        }
    }

    public boolean canDeployToComponent(String componentName) {
        ComponentMBeanImpl lcc = this.container.getComponent(componentName);
        return lcc != null && lcc.isStarted() && lcc.getServiceUnitManager() != null;
    }

    public String start(String serviceAssemblyName) throws Exception {
        try {
            ServiceAssemblyLifeCycle sa = this.registry.getServiceAssembly(serviceAssemblyName);
            return sa.start(true);
        }
        catch (Exception e) {
            log.info((Object)"Error in start", (Throwable)e);
            throw e;
        }
    }

    public String stop(String serviceAssemblyName) throws Exception {
        try {
            ServiceAssemblyLifeCycle sa = this.registry.getServiceAssembly(serviceAssemblyName);
            return sa.stop(true, false);
        }
        catch (Exception e) {
            log.info((Object)"Error in stop", (Throwable)e);
            throw e;
        }
    }

    public String shutDown(String serviceAssemblyName) throws Exception {
        try {
            ServiceAssemblyLifeCycle sa = this.registry.getServiceAssembly(serviceAssemblyName);
            return sa.shutDown(true);
        }
        catch (Exception e) {
            log.info((Object)"Error in shutDown", (Throwable)e);
            throw e;
        }
    }

    public String getState(String serviceAssemblyName) throws Exception {
        try {
            ServiceAssemblyLifeCycle sa = this.registry.getServiceAssembly(serviceAssemblyName);
            return sa.getCurrentState();
        }
        catch (Exception e) {
            log.info((Object)"Error in getState", (Throwable)e);
            throw e;
        }
    }

    protected boolean isSaDeployed(String serviceAssemblyName) {
        return this.registry.getServiceAssembly(serviceAssemblyName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String deployServiceAssembly(File tmpDir, ServiceAssembly sa) throws Exception {
        String assemblyName = sa.getIdentification().getName();
        ServiceAssemblyEnvironment env = this.environmentContext.getNewServiceAssemblyEnvironment(assemblyName);
        File saDirectory = env.getInstallDir();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Moving " + tmpDir.getAbsolutePath() + " to " + saDirectory.getAbsolutePath()));
        }
        saDirectory.getParentFile().mkdirs();
        if (!tmpDir.renameTo(saDirectory)) {
            throw ManagementSupport.failure("deploy", "Failed to rename " + tmpDir + " to " + saDirectory);
        }
        ServiceUnit[] sus = sa.getServiceUnits();
        if (sus != null) {
            for (int i = 0; i < sus.length; ++i) {
                String suName = sus[i].getIdentification().getName();
                String artifact = sus[i].getTarget().getArtifactsZip();
                String componentName = sus[i].getTarget().getComponentName();
                File artifactFile = new File(saDirectory, artifact);
                if (!artifactFile.exists()) {
                    throw ManagementSupport.failure("deploy", "Artifact " + artifact + " not found for service unit " + suName);
                }
                ComponentMBeanImpl lcc = this.container.getComponent(componentName);
                if (lcc == null) {
                    throw ManagementSupport.failure("deploy", "Target component " + componentName + " for service unit " + suName + " is not installed");
                }
                if (!lcc.isStarted()) {
                    throw ManagementSupport.failure("deploy", "Target component " + componentName + " for service unit " + suName + " is not started");
                }
                if (lcc.getServiceUnitManager() == null) {
                    throw ManagementSupport.failure("deploy", "Target component " + componentName + " for service unit " + suName + " does not accept deployments");
                }
                if (!this.isDeployedServiceUnit(componentName, suName)) continue;
                throw ManagementSupport.failure("deploy", "Service unit " + suName + " is already deployed on component " + componentName);
            }
        }
        int nbSuccess = 0;
        int nbFailures = 0;
        ArrayList<Element> componentResults = new ArrayList<Element>();
        ArrayList<String> suKeys = new ArrayList<String>();
        if (sus != null) {
            for (int i = 0; i < sus.length; ++i) {
                File targetDir = null;
                String suName = sus[i].getIdentification().getName();
                String artifact = sus[i].getTarget().getArtifactsZip();
                String componentName = sus[i].getTarget().getComponentName();
                try {
                    File artifactFile = new File(saDirectory, artifact);
                    targetDir = env.getServiceUnitDirectory(componentName, suName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Unpack service unit archive " + artifactFile + " to " + targetDir));
                    }
                    FileUtil.unpackArchive(artifactFile, targetDir);
                }
                catch (IOException e) {
                    ++nbFailures;
                    componentResults.add(ManagementSupport.createComponentFailure("deploy", componentName, "Error unpacking service unit", e));
                    continue;
                }
                boolean success = false;
                try {
                    ComponentMBeanImpl lcc = this.container.getComponent(componentName);
                    ServiceUnitManager sum = lcc.getServiceUnitManager();
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(lcc.getComponent().getClass().getClassLoader());
                        String resultMsg = sum.deploy(suName, targetDir.getAbsolutePath());
                        success = this.getComponentTaskResult(resultMsg, componentName, componentResults, true);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(cl);
                    }
                }
                catch (Exception e) {
                    this.getComponentTaskError(e, componentName, componentResults);
                }
                if (success) {
                    ++nbSuccess;
                    suKeys.add(this.registry.registerServiceUnit(sus[i], assemblyName, targetDir));
                    continue;
                }
                ++nbFailures;
            }
        }
        if (nbFailures > 0) {
            Iterator iter = suKeys.iterator();
            while (iter.hasNext()) {
                try {
                    String suName = (String)iter.next();
                    ServiceUnitLifeCycle su = this.registry.getServiceUnit(suName);
                    this.undeployServiceUnit(su);
                }
                catch (Exception e) {
                    log.warn((Object)"Error undeploying SU", (Throwable)e);
                }
            }
            FileUtil.deleteFile(saDirectory);
            throw ManagementSupport.failure("deploy", componentResults);
        }
        String[] deployedSUs = suKeys.toArray(new String[suKeys.size()]);
        ServiceAssemblyLifeCycle salc = this.registry.registerServiceAssembly(sa, deployedSUs, env);
        salc.writeRunningState();
        if (nbFailures > 0) {
            return ManagementSupport.createWarningMessage("deploy", "Failed to deploy some service units", componentResults);
        }
        return ManagementSupport.createSuccessMessage("deploy", componentResults);
    }

    protected void getComponentTaskError(Exception exception, String component, List<Element> results) {
        Element result = null;
        try {
            Document doc = this.parse(exception.getMessage());
            result = this.getElement(doc, "component-task-result");
        }
        catch (Exception e) {
            result = ManagementSupport.createComponentFailure("deploy", component, "Unable to parse result string", exception);
        }
        if (result != null) {
            results.add(result);
        }
    }

    protected boolean getComponentTaskResult(String resultMsg, String component, List<Element> results, boolean success) {
        Element result = null;
        try {
            Document doc = this.parse(resultMsg);
            result = this.getElement(doc, "component-task-result");
            Element e = this.getChildElement(result, "component-task-result-details");
            e = this.getChildElement(e, "task-result-details");
            e = this.getChildElement(e, "task-result");
            String r = DOMUtil.getElementText(e);
            if (!"SUCCESS".equals(r)) {
                success = false;
            }
        }
        catch (Exception e) {
            try {
                result = success ? ManagementSupport.createComponentWarning("deploy", component, "Unable to parse result string", e) : ManagementSupport.createComponentFailure("deploy", component, "Unable to parse result string", e);
            }
            catch (Exception e2) {
                log.error((Object)e2);
                result = null;
            }
        }
        if (result != null) {
            results.add(result);
        }
        return success;
    }

    protected Document parse(String result) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new InputSource(new StringReader(result)));
    }

    protected Element getElement(Document doc, String name) {
        NodeList l = doc.getElementsByTagNameNS("http://java.sun.com/xml/ns/jbi/management-message", name);
        Element e = (Element)l.item(0);
        return e;
    }

    protected Element getChildElement(Element element, String name) {
        NodeList l = element.getElementsByTagNameNS("http://java.sun.com/xml/ns/jbi/management-message", name);
        Element e = (Element)l.item(0);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeployServiceUnit(ServiceUnitLifeCycle su) throws DeploymentException {
        String name = su.getName();
        String componentName = su.getComponentName();
        File targetDir = su.getServiceUnitRootPath();
        this.registry.unregisterServiceUnit(su.getKey());
        ComponentMBeanImpl component = this.container.getComponent(componentName);
        if (component != null) {
            ServiceUnitManager sum = component.getServiceUnitManager();
            if (sum != null) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(component.getComponent().getClass().getClassLoader());
                    sum.undeploy(name, targetDir.getAbsolutePath());
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cl);
                }
                FileUtil.deleteFile(targetDir);
            }
        } else {
            FileUtil.deleteFile(targetDir);
        }
        log.info((Object)("UnDeployed ServiceUnit " + name + " from Component: " + componentName));
    }

    protected void buildState() {
        File[] files;
        log.info((Object)"Restoring service assemblies");
        File top = this.environmentContext.getServiceAssembliesDir();
        if (top != null && top.exists() && top.isDirectory() && (files = top.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                String assemblyName = files[i].getName();
                try {
                    ServiceAssembly sa;
                    ServiceAssemblyEnvironment env = this.environmentContext.getServiceAssemblyEnvironment(assemblyName);
                    Descriptor root = DescriptorFactory.buildDescriptor(env.getInstallDir());
                    if (root == null || (sa = root.getServiceAssembly()) == null || sa.getIdentification() == null) continue;
                    this.registry.registerServiceAssembly(sa, env);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("Failed to initialized service assembly: " + assemblyName), (Throwable)e);
                }
            }
        }
    }
}

