/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import javax.jbi.management.InstallationServiceMBean;
import javax.jbi.management.InstallerMBean;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.container.ComponentEnvironment;
import org.apache.servicemix.jbi.container.EnvironmentContext;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.deployment.Component;
import org.apache.servicemix.jbi.deployment.Descriptor;
import org.apache.servicemix.jbi.deployment.DescriptorFactory;
import org.apache.servicemix.jbi.deployment.SharedLibrary;
import org.apache.servicemix.jbi.framework.AutoDeploymentService;
import org.apache.servicemix.jbi.framework.ComponentContextImpl;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.framework.ComponentNameSpace;
import org.apache.servicemix.jbi.framework.InstallationContextImpl;
import org.apache.servicemix.jbi.framework.InstallerMBeanImpl;
import org.apache.servicemix.jbi.management.BaseSystemService;
import org.apache.servicemix.jbi.management.ManagementContext;
import org.apache.servicemix.jbi.management.OperationInfoHelper;
import org.apache.servicemix.jbi.management.ParameterHelper;
import org.apache.servicemix.jbi.util.FileUtil;
import org.apache.servicemix.jbi.util.FileVersionUtil;

public class InstallationService
extends BaseSystemService
implements InstallationServiceMBean {
    private static final Log log = LogFactory.getLog(InstallationService.class);
    private EnvironmentContext environmentContext;
    private ManagementContext managementContext;
    private Map<String, InstallerMBeanImpl> installers = new ConcurrentHashMap<String, InstallerMBeanImpl>();
    private Map<String, InstallerMBeanImpl> nonLoadedInstallers = new ConcurrentHashMap<String, InstallerMBeanImpl>();

    public String getDescription() {
        return "installs/uninstalls Components";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized ObjectName loadNewInstaller(String installJarURL) {
        try {
            File tmpDir;
            ObjectName result = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading new installer from " + installJarURL));
            }
            if ((tmpDir = AutoDeploymentService.unpackLocation(this.environmentContext.getTmpDir(), installJarURL)) == null) throw new RuntimeException("location: " + installJarURL + " isn't valid");
            Descriptor root = DescriptorFactory.buildDescriptor(tmpDir);
            if (root == null || root.getComponent() == null) throw new RuntimeException("Could not find Component from: " + installJarURL);
            String componentName = root.getComponent().getIdentification().getName();
            if (this.installers.containsKey(componentName)) throw new RuntimeException("An installer already exists for " + componentName);
            InstallerMBeanImpl installer = this.doInstallArchive(tmpDir, root);
            if (installer == null) return result;
            result = installer.getObjectName();
            this.installers.put(componentName, installer);
            return result;
        }
        catch (Throwable t) {
            log.error((Object)"Deployment failed", t);
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (!(t instanceof RuntimeException)) throw new RuntimeException("Deployment failed: " + t.getMessage());
            throw (RuntimeException)t;
        }
    }

    public ObjectName loadInstaller(String aComponentName) {
        InstallerMBeanImpl installer = this.installers.get(aComponentName);
        if (installer == null && (installer = this.nonLoadedInstallers.get(aComponentName)) != null) {
            try {
                ObjectName objectName = this.managementContext.createCustomComponentMBeanName("Installer", aComponentName);
                installer.setObjectName(objectName);
                this.managementContext.registerMBean(objectName, installer, InstallerMBean.class, "standard installation controls for a Component");
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load installer", e);
            }
            return installer.getObjectName();
        }
        return null;
    }

    private InstallerMBeanImpl createInstaller(String componentName) throws IOException, DeploymentException {
        File installationDir = this.environmentContext.getComponentInstallationDir(componentName);
        Descriptor root = DescriptorFactory.buildDescriptor(installationDir);
        Component descriptor = root.getComponent();
        InstallationContextImpl installationContext = new InstallationContextImpl(descriptor);
        installationContext.setInstall(false);
        installationContext.setInstallRoot(installationDir);
        File componentRoot = this.environmentContext.getComponentRootDir(componentName);
        ComponentContextImpl context = this.buildComponentContext(componentRoot, installationDir, componentName);
        installationContext.setContext(context);
        InstallerMBeanImpl installer = new InstallerMBeanImpl(this.container, installationContext);
        return installer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unloadInstaller(String componentName, boolean isToBeDeleted) {
        boolean result = false;
        try {
            this.container.getBroker().suspend();
            InstallerMBeanImpl installer = this.installers.remove(componentName);
            boolean bl = result = installer != null;
            if (result) {
                this.container.getManagementContext().unregisterMBean(installer);
                if (isToBeDeleted) {
                    installer.uninstall();
                } else {
                    this.nonLoadedInstallers.put(componentName, installer);
                }
            }
        }
        catch (JBIException e) {
            String errStr = "Problem shutting down Component: " + componentName;
            log.error((Object)errStr, (Throwable)e);
        }
        finally {
            this.container.getBroker().resume();
        }
        return result;
    }

    public String installSharedLibrary(String aSharedLibURI) {
        String result = "";
        try {
            SharedLibrary sl;
            File tmpDir = AutoDeploymentService.unpackLocation(this.environmentContext.getTmpDir(), aSharedLibURI);
            if (tmpDir != null) {
                Descriptor root = DescriptorFactory.buildDescriptor(tmpDir);
                if (root == null) {
                    throw new DeploymentException("Could not find JBI descriptor");
                }
                sl = root.getSharedLibrary();
                if (sl == null) {
                    throw new DeploymentException("JBI descriptor is not a SharedLibrary descriptor");
                }
            } else {
                throw new DeploymentException("Could not find JBI descriptor");
            }
            result = this.doInstallSharedLibrary(tmpDir, sl);
        }
        catch (DeploymentException e) {
            log.error((Object)"Deployment failed", (Throwable)e);
        }
        return result;
    }

    public boolean uninstallSharedLibrary(String aSharedLibName) {
        this.container.getRegistry().unregisterSharedLibrary(aSharedLibName);
        this.environmentContext.removeSharedLibraryDirectory(aSharedLibName);
        return true;
    }

    public void init(JBIContainer container) throws JBIException {
        super.init(container);
        this.environmentContext = container.getEnvironmentContext();
        this.managementContext = container.getManagementContext();
        this.buildState();
    }

    protected Class getServiceMBean() {
        return InstallationServiceMBean.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void install(String location, Properties props, boolean autoStart) throws DeploymentException {
        File tmpDir = AutoDeploymentService.unpackLocation(this.environmentContext.getTmpDir(), location);
        if (tmpDir == null) throw new DeploymentException("Could not find JBI descriptor");
        Descriptor root = DescriptorFactory.buildDescriptor(tmpDir);
        if (root == null) throw new DeploymentException("Could not find JBI descriptor");
        if (root.getComponent() == null) {
            throw new DeploymentException("JBI descriptor is not a component descriptor");
        }
        this.install(tmpDir, props, root, autoStart);
    }

    protected void install(File tmpDir, Properties props, Descriptor root, boolean autoStart) throws DeploymentException {
        if (root.getComponent() != null) {
            String componentName = root.getComponent().getIdentification().getName();
            if (this.installers.containsKey(componentName)) {
                throw new DeploymentException("Component " + componentName + " is already installed");
            }
            InstallerMBeanImpl installer = this.doInstallArchive(tmpDir, root);
            if (installer != null) {
                try {
                    if (props != null && props.size() > 0) {
                        ObjectName on = installer.getInstallerConfigurationMBean();
                        if (on == null) {
                            log.warn((Object)"Could not find installation configuration MBean. Installation properties will be ignored.");
                        } else {
                            MBeanServer mbs = this.managementContext.getMBeanServer();
                            for (String string : props.keySet()) {
                                String val = props.getProperty(string);
                                try {
                                    mbs.setAttribute(on, new Attribute(string, val));
                                }
                                catch (JMException e) {
                                    throw new DeploymentException("Could not set installation property: (" + string + " = " + val, (Throwable)e);
                                }
                            }
                        }
                    }
                    installer.install();
                }
                catch (JBIException e) {
                    throw new DeploymentException((Throwable)e);
                }
                if (autoStart) {
                    try {
                        ComponentMBeanImpl lcc = this.container.getComponent(componentName);
                        if (lcc != null) {
                            lcc.start();
                        } else {
                            log.warn((Object)("No ComponentConnector found for Component " + componentName));
                        }
                    }
                    catch (JBIException e) {
                        String errStr = "Failed to start Component: " + componentName;
                        log.error((Object)errStr, (Throwable)e);
                        throw new DeploymentException((Throwable)e);
                    }
                }
                this.installers.put(componentName, installer);
            }
        }
    }

    public MBeanOperationInfo[] getOperationInfos() throws JMException {
        OperationInfoHelper helper = new OperationInfoHelper();
        ParameterHelper ph = helper.addOperation(this.getObjectToManage(), "loadNewInstaller", 1, "load a new Installer ");
        ph.setDescription(0, "installJarURL", "URL locating the install Jar");
        ph = helper.addOperation(this.getObjectToManage(), "loadInstaller", 1, "load installer for a previously installed component");
        ph.setDescription(0, "componentName", "Name of the Component");
        ph = helper.addOperation(this.getObjectToManage(), "unloadInstaller", 2, "unload an installer");
        ph.setDescription(0, "componentName", "Name of the Component");
        ph.setDescription(1, "isToBeDeleted", "true if component is to be deleted");
        ph = helper.addOperation(this.getObjectToManage(), "installSharedLibrary", 1, "Install a shared library jar");
        ph.setDescription(0, "sharedLibURI", "URI for the jar to be installed");
        ph = helper.addOperation(this.getObjectToManage(), "uninstallSharedLibrary", 1, "Uninstall a shared library jar");
        ph.setDescription(0, "sharedLibName", "name of the shared library");
        ph = helper.addOperation(this.getObjectToManage(), "install", 1, "install and deplot an archive");
        ph.setDescription(0, "location", "location of archive");
        ph = helper.addOperation(this.getObjectToManage(), "install", 2, "install and deplot an archive");
        ph.setDescription(0, "location", "location of archive");
        ph.setDescription(1, "autostart", "automatically start the Component");
        return OperationInfoHelper.join(super.getOperationInfos(), helper.getOperationInfos());
    }

    protected InstallerMBeanImpl doInstallArchive(File tmpDirectory, Descriptor descriptor) throws DeploymentException {
        InstallerMBeanImpl installer = null;
        Component component = descriptor.getComponent();
        if (component != null) {
            installer = this.doInstallComponent(tmpDirectory, component);
        }
        return installer;
    }

    protected String doInstallSharedLibrary(File tmpDirectory, SharedLibrary descriptor) throws DeploymentException {
        String result = null;
        if (descriptor != null) {
            File installationDir = null;
            try {
                result = descriptor.getIdentification().getName();
                File rootDir = this.environmentContext.createSharedLibraryDirectory(result);
                installationDir = FileVersionUtil.getNewVersionDirectory(rootDir);
                if (!tmpDirectory.renameTo(installationDir)) {
                    throw new DeploymentException("Unable to rename " + tmpDirectory + " to " + installationDir);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Moved " + tmpDirectory + " to " + installationDir));
                }
                this.container.getRegistry().registerSharedLibrary(descriptor, installationDir);
            }
            catch (Exception e) {
                log.error((Object)"Deployment of Shared Library failed", (Throwable)e);
                FileUtil.deleteFile(installationDir);
                throw new DeploymentException((Throwable)e);
            }
            finally {
                FileUtil.deleteFile(tmpDirectory);
            }
        }
        return result;
    }

    protected InstallerMBeanImpl doInstallComponent(File tmpDirectory, Component descriptor) throws DeploymentException {
        InstallerMBeanImpl result = null;
        String name = descriptor.getIdentification().getName();
        try {
            File oldInstallationDir = this.environmentContext.getComponentInstallationDir(name);
            if (!FileUtil.deleteFile(oldInstallationDir)) {
                log.warn((Object)("Failed to delete old installation directory: " + oldInstallationDir.getPath()));
            }
            File componentRoot = this.environmentContext.createComponentRootDir(name);
            File installationDir = this.environmentContext.getNewComponentInstallationDir(name);
            tmpDirectory.renameTo(installationDir);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Moved " + tmpDirectory + " to " + installationDir));
            }
            result = this.initializeInstaller(installationDir, componentRoot, descriptor);
            return result;
        }
        catch (IOException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private InstallerMBeanImpl initializeInstaller(File installationDir, File componentRoot, Component descriptor) throws DeploymentException {
        InstallerMBeanImpl result = null;
        try {
            String name = descriptor.getIdentification().getName();
            InstallationContextImpl installationContext = new InstallationContextImpl(descriptor);
            installationContext.setInstall(true);
            installationContext.setInstallRoot(installationDir);
            ComponentContextImpl context = this.buildComponentContext(componentRoot, installationDir, name);
            installationContext.setContext(context);
            result = new InstallerMBeanImpl(this.container, installationContext);
            ObjectName objectName = this.managementContext.createCustomComponentMBeanName("Installer", name);
            result.setObjectName(objectName);
            this.managementContext.registerMBean(objectName, result, InstallerMBean.class, "standard installation controls for a Component");
        }
        catch (Throwable e) {
            log.error((Object)"Deployment of Component failed", e);
            this.environmentContext.removeComponentRootDirectory(descriptor.getIdentification().getName());
            throw new DeploymentException(e);
        }
        return result;
    }

    protected void buildState() {
        this.buildSharedLibs();
        this.buildComponents();
    }

    protected boolean containsSharedLibrary(String name) {
        return this.container.getRegistry().getSharedLibrary(name) != null;
    }

    protected void buildSharedLibs() {
        File[] files;
        File top = this.environmentContext.getSharedLibDir();
        if (top != null && top.exists() && top.isDirectory() && (files = top.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                SharedLibrary sl;
                Descriptor root;
                File dir;
                if (!files[i].isDirectory() || (dir = FileVersionUtil.getLatestVersionDirectory(files[i])) == null || (root = DescriptorFactory.buildDescriptor(dir)) == null || (sl = root.getSharedLibrary()) == null) continue;
                try {
                    this.container.getRegistry().registerSharedLibrary(sl, dir);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"Failed to initialize sharted library", (Throwable)e);
                }
            }
        }
    }

    protected void buildComponents() {
        File[] files;
        File top = this.environmentContext.getComponentsDir();
        if (top != null && top.exists() && top.isDirectory() && (files = top.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                File directory = files[i];
                try {
                    this.buildComponent(directory);
                    continue;
                }
                catch (DeploymentException e) {
                    log.error((Object)("Could not build Component: " + directory.getName()), (Throwable)e);
                    log.warn((Object)("Deleting Component directory: " + directory));
                    FileUtil.deleteFile(directory);
                }
            }
        }
    }

    protected void buildComponent(File componentDirectory) throws DeploymentException {
        try {
            String componentName = componentDirectory.getName();
            ComponentEnvironment env = this.container.getEnvironmentContext().getComponentEnvironment(componentName);
            if (!env.getStateFile().exists()) {
                FileUtil.deleteFile(componentDirectory);
            } else {
                InstallerMBeanImpl installer = this.createInstaller(componentName);
                installer.activateComponent();
                this.nonLoadedInstallers.put(componentName, installer);
            }
        }
        catch (Throwable e) {
            log.error((Object)("Failed to deploy component: " + componentDirectory.getName()), e);
            throw new DeploymentException(e);
        }
    }

    protected ComponentContextImpl buildComponentContext(File componentRoot, File installRoot, String name) throws IOException {
        ComponentNameSpace cns = new ComponentNameSpace(this.container.getName(), name);
        ComponentContextImpl context = new ComponentContextImpl(this.container, cns);
        ComponentEnvironment env = new ComponentEnvironment();
        FileUtil.buildDirectory(componentRoot);
        File privateWorkspace = this.environmentContext.createWorkspaceDirectory(name);
        env.setWorkspaceRoot(privateWorkspace);
        env.setComponentRoot(componentRoot);
        env.setInstallRoot(installRoot);
        context.setEnvironment(env);
        return context;
    }
}

