/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.jbi.management.DeploymentException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ManagementSupport {
    private static final Log logger = LogFactory.getLog(ManagementSupport.class);

    public static Exception failure(String task, String info) throws Exception {
        return ManagementSupport.failure(task, info, null, null);
    }

    public static Exception failure(String task, List componentResults) throws Exception {
        return ManagementSupport.failure(task, null, null, componentResults);
    }

    public static Exception failure(String task, String info, Exception e) throws Exception {
        return ManagementSupport.failure(task, info, e, null);
    }

    public static Exception failure(String task, String info, Exception e, List componentResults) throws Exception {
        Message msg = new Message();
        msg.setTask(task);
        msg.setResult("FAILED");
        msg.setType("ERROR");
        msg.setException(e);
        msg.setMessage(info);
        return new Exception(ManagementSupport.createFrameworkMessage(msg, componentResults));
    }

    public static String createSuccessMessage(String task) {
        return ManagementSupport.createSuccessMessage(task, null, null);
    }

    public static String createSuccessMessage(String task, List componentResults) {
        return ManagementSupport.createSuccessMessage(task, null, componentResults);
    }

    public static String createSuccessMessage(String task, String info) {
        return ManagementSupport.createSuccessMessage(task, info, null);
    }

    public static String createSuccessMessage(String task, String info, List componentResults) {
        Message msg = new Message();
        msg.setTask(task);
        msg.setResult("SUCCESS");
        msg.setMessage(info);
        return ManagementSupport.createFrameworkMessage(msg, componentResults);
    }

    public static String createWarningMessage(String task, String info, List componentResults) {
        Message msg = new Message();
        msg.setTask(task);
        msg.setResult("SUCCESS");
        msg.setType("WARNING");
        msg.setMessage(info);
        return ManagementSupport.createFrameworkMessage(msg, componentResults);
    }

    public static String createFrameworkMessage(Message fmkMsg, List componentResults) {
        try {
            Document doc = ManagementSupport.createDocument();
            Element jbiTask = ManagementSupport.createChild(doc, "jbi-task");
            jbiTask.setAttribute("xmlns", "http://java.sun.com/xml/ns/jbi/management-message");
            jbiTask.setAttribute("version", "1.0");
            Element jbiTaskResult = ManagementSupport.createChild(jbiTask, "jbi-task-result");
            Element frmkTaskResult = ManagementSupport.createChild(jbiTaskResult, "frmwk-task-result");
            Element frmkTaskResultDetails = ManagementSupport.createChild(frmkTaskResult, "frmwk-task-result-details");
            ManagementSupport.appendTaskResultDetails(frmkTaskResultDetails, fmkMsg);
            if (fmkMsg.getLocale() != null) {
                ManagementSupport.createChild(frmkTaskResult, "locale", fmkMsg.getLocale());
            }
            if (componentResults != null) {
                for (Element element : componentResults) {
                    jbiTaskResult.appendChild(doc.importNode(element, true));
                }
            }
            return DOMUtil.asIndentedXML(doc);
        }
        catch (Exception e) {
            logger.error((Object)"Error", (Throwable)e);
            return null;
        }
    }

    private static Document createDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create DOM document", e);
        }
    }

    private static Element createChild(Node parent, String name) {
        return ManagementSupport.createChild(parent, name, null);
    }

    private static Element createChild(Node parent, String name, String text) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element child = doc.createElementNS("http://java.sun.com/xml/ns/jbi/management-message", name);
        if (text != null) {
            child.appendChild(doc.createTextNode(text));
        }
        parent.appendChild(child);
        return child;
    }

    private static void appendTaskResultDetails(Element root, Message fmkMsg) {
        Element taskResultDetails = ManagementSupport.createChild(root, "task-result-details");
        ManagementSupport.createChild(taskResultDetails, "task-id", fmkMsg.getTask());
        ManagementSupport.createChild(taskResultDetails, "task-result", fmkMsg.getResult());
        if (fmkMsg.getType() != null) {
            ManagementSupport.createChild(taskResultDetails, "message-type", fmkMsg.getType());
        }
        if (fmkMsg.getMessage() != null) {
            Element taskStatusMessage = ManagementSupport.createChild(taskResultDetails, "task-status-msg");
            Element msgLocInfo = ManagementSupport.createChild(taskStatusMessage, "msg-loc-info");
            ManagementSupport.createChild(msgLocInfo, "loc-token");
            ManagementSupport.createChild(msgLocInfo, "loc-message", fmkMsg.getMessage());
        }
        if (fmkMsg.getException() != null) {
            Element exceptionInfo = ManagementSupport.createChild(taskResultDetails, "exception-info");
            ManagementSupport.createChild(exceptionInfo, "nesting-level", "1");
            ManagementSupport.createChild(exceptionInfo, "loc-token");
            ManagementSupport.createChild(exceptionInfo, "loc-message", fmkMsg.getException().getMessage());
            Element stackTrace = ManagementSupport.createChild(exceptionInfo, "stack-trace");
            StringWriter sw2 = new StringWriter();
            PrintWriter pw = new PrintWriter(sw2);
            fmkMsg.getException().printStackTrace(pw);
            pw.close();
            stackTrace.appendChild(root.getOwnerDocument().createCDATASection(sw2.toString()));
        }
    }

    public static DeploymentException componentFailure(String task, String component, String info) {
        try {
            Element e = ManagementSupport.createComponentFailure(task, component, info, null);
            return new DeploymentException(DOMUtil.asXML(e));
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Error creating management message", (Throwable)e);
            }
            return new DeploymentException(info);
        }
    }

    public static Element createComponentMessage(Message msg) {
        Document doc = ManagementSupport.createDocument();
        Element componentTaskResult = ManagementSupport.createChild(doc, "component-task-result");
        ManagementSupport.createChild(componentTaskResult, "component-name", msg.getComponent());
        Element componentTaskResultDetails = ManagementSupport.createChild(componentTaskResult, "component-task-result-details");
        ManagementSupport.appendTaskResultDetails(componentTaskResultDetails, msg);
        return componentTaskResult;
    }

    public static Element createComponentSuccess(String task, String component) {
        Message msg = new Message();
        msg.setTask(task);
        msg.setResult("SUCCESS");
        msg.setComponent(component);
        return ManagementSupport.createComponentMessage(msg);
    }

    public static Element createComponentFailure(String task, String component, String info, Exception e) {
        Message msg = new Message();
        msg.setTask(task);
        msg.setResult("FAILED");
        msg.setType("ERROR");
        msg.setException(e);
        msg.setMessage(info);
        msg.setComponent(component);
        return ManagementSupport.createComponentMessage(msg);
    }

    public static Element createComponentWarning(String task, String component, String info, Exception e) {
        Message msg = new Message();
        msg.setTask(task);
        msg.setResult("SUCCESS");
        msg.setType("WARNING");
        msg.setException(e);
        msg.setMessage(info);
        msg.setComponent(component);
        return ManagementSupport.createComponentMessage(msg);
    }

    public static class Message {
        private boolean isCauseFramework;
        private String task;
        private String result;
        private Exception exception;
        private String type;
        private String message;
        private String component;
        private String locale;

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public boolean isCauseFramework() {
            return this.isCauseFramework;
        }

        public void setCauseFramework(boolean isCauseFramework) {
            this.isCauseFramework = isCauseFramework;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public String getTask() {
            return this.task;
        }

        public void setTask(String task) {
            this.task = task;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getComponent() {
            return this.component;
        }

        public void setComponent(String component) {
            this.component = component;
        }

        public String getLocale() {
            return this.locale;
        }

        public void setLocale(String locale) {
            this.locale = locale;
        }
    }
}

