/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Properties;
import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.container.ServiceAssemblyEnvironment;
import org.apache.servicemix.jbi.deployment.Connection;
import org.apache.servicemix.jbi.deployment.Consumes;
import org.apache.servicemix.jbi.deployment.DescriptorFactory;
import org.apache.servicemix.jbi.deployment.ServiceAssembly;
import org.apache.servicemix.jbi.deployment.Services;
import org.apache.servicemix.jbi.event.ServiceAssemblyEvent;
import org.apache.servicemix.jbi.event.ServiceAssemblyListener;
import org.apache.servicemix.jbi.framework.ManagementSupport;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.framework.ServiceAssemblyMBean;
import org.apache.servicemix.jbi.framework.ServiceUnitLifeCycle;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.MBeanInfoProvider;
import org.apache.servicemix.jbi.management.OperationInfoHelper;
import org.apache.servicemix.jbi.util.XmlPersistenceSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ServiceAssemblyLifeCycle
implements ServiceAssemblyMBean,
MBeanInfoProvider {
    private static final Log log = LogFactory.getLog(ServiceAssemblyLifeCycle.class);
    private ServiceAssembly serviceAssembly;
    private String currentState = "Shutdown";
    private ServiceUnitLifeCycle[] sus;
    private Registry registry;
    private PropertyChangeListener listener;
    private ServiceAssemblyEnvironment env;

    public ServiceAssemblyLifeCycle(ServiceAssembly sa, ServiceAssemblyEnvironment env, Registry registry) {
        this.serviceAssembly = sa;
        this.env = env;
        this.registry = registry;
    }

    protected void setServiceUnits(ServiceUnitLifeCycle[] sus) {
        this.sus = sus;
    }

    public String start() throws Exception {
        return this.start(true);
    }

    public synchronized String start(boolean writeState) throws Exception {
        int i;
        log.info((Object)("Starting service assembly: " + this.getName()));
        try {
            this.startConnections();
        }
        catch (JBIException e) {
            throw ManagementSupport.failure("start", e.getMessage());
        }
        ArrayList<Element> componentFailures = new ArrayList<Element>();
        for (i = 0; i < this.sus.length; ++i) {
            if (!this.sus[i].isShutDown()) continue;
            try {
                this.sus[i].init();
                continue;
            }
            catch (DeploymentException e) {
                componentFailures.add(this.getComponentFailure((Exception)((Object)e), "start", this.sus[i].getComponentName()));
            }
        }
        for (i = 0; i < this.sus.length; ++i) {
            if (!this.sus[i].isStopped()) continue;
            try {
                this.sus[i].start();
                continue;
            }
            catch (DeploymentException e) {
                componentFailures.add(this.getComponentFailure((Exception)((Object)e), "start", this.sus[i].getComponentName()));
            }
        }
        if (componentFailures.size() == 0) {
            this.currentState = "Started";
            if (writeState) {
                this.writeRunningState();
            }
            this.fireEvent(1);
            return ManagementSupport.createSuccessMessage("start");
        }
        throw ManagementSupport.failure("start", componentFailures);
    }

    public String stop() throws Exception {
        return this.stop(true, false);
    }

    public synchronized String stop(boolean writeState, boolean forceInit) throws Exception {
        int i;
        log.info((Object)("Stopping service assembly: " + this.getName()));
        this.stopConnections();
        ArrayList<Element> componentFailures = new ArrayList<Element>();
        if (forceInit) {
            for (i = 0; i < this.sus.length; ++i) {
                try {
                    this.sus[i].init();
                    continue;
                }
                catch (DeploymentException e) {
                    componentFailures.add(this.getComponentFailure((Exception)((Object)e), "stop", this.sus[i].getComponentName()));
                }
            }
        }
        for (i = 0; i < this.sus.length; ++i) {
            if (!this.sus[i].isStarted()) continue;
            try {
                this.sus[i].stop();
                continue;
            }
            catch (DeploymentException e) {
                componentFailures.add(this.getComponentFailure((Exception)((Object)e), "stop", this.sus[i].getComponentName()));
            }
        }
        if (componentFailures.size() == 0) {
            this.currentState = "Stopped";
            if (writeState) {
                this.writeRunningState();
            }
            this.fireEvent(2);
            return ManagementSupport.createSuccessMessage("stop");
        }
        throw ManagementSupport.failure("stop", componentFailures);
    }

    public String shutDown() throws Exception {
        return this.shutDown(true);
    }

    public synchronized String shutDown(boolean writeState) throws Exception {
        int i;
        log.info((Object)("Shutting down service assembly: " + this.getName()));
        ArrayList<Element> componentFailures = new ArrayList<Element>();
        for (i = 0; i < this.sus.length; ++i) {
            if (!this.sus[i].isStarted()) continue;
            try {
                this.sus[i].stop();
                continue;
            }
            catch (DeploymentException e) {
                componentFailures.add(this.getComponentFailure((Exception)((Object)e), "shutDown", this.sus[i].getComponentName()));
            }
        }
        for (i = 0; i < this.sus.length; ++i) {
            if (!this.sus[i].isStopped()) continue;
            try {
                this.sus[i].shutDown();
                continue;
            }
            catch (DeploymentException e) {
                componentFailures.add(this.getComponentFailure((Exception)((Object)e), "shutDown", this.sus[i].getComponentName()));
            }
        }
        if (componentFailures.size() == 0) {
            this.currentState = "Shutdown";
            if (writeState) {
                this.writeRunningState();
            }
            this.fireEvent(3);
            return ManagementSupport.createSuccessMessage("shutDown");
        }
        throw ManagementSupport.failure("shutDown", componentFailures);
    }

    public String getCurrentState() {
        return this.currentState;
    }

    boolean isShutDown() {
        return this.currentState.equals("Shutdown");
    }

    boolean isStopped() {
        return this.currentState.equals("Stopped");
    }

    boolean isStarted() {
        return this.currentState.equals("Started");
    }

    public String getName() {
        return this.serviceAssembly.getIdentification().getName();
    }

    public String getDescription() {
        return this.serviceAssembly.getIdentification().getDescription();
    }

    public ServiceAssembly getServiceAssembly() {
        return this.serviceAssembly;
    }

    public String getDescriptor() {
        File saDir = this.env.getInstallDir();
        return DescriptorFactory.getDescriptorAsText(saDir);
    }

    public String toString() {
        return "ServiceAssemblyLifeCycle[name=" + this.getName() + ",state=" + this.getCurrentState() + "]";
    }

    void writeRunningState() {
        try {
            if (this.env.getStateFile() != null) {
                String currentState = this.getCurrentState();
                Properties props = new Properties();
                props.setProperty("state", currentState);
                XmlPersistenceSupport.write(this.env.getStateFile(), props);
            }
        }
        catch (IOException e) {
            log.error((Object)("Failed to write current running state for ServiceAssembly: " + this.getName()), (Throwable)e);
        }
    }

    String getRunningStateFromStore() {
        try {
            if (this.env.getStateFile() != null && this.env.getStateFile().exists()) {
                Properties props = (Properties)XmlPersistenceSupport.read(this.env.getStateFile());
                return props.getProperty("state", "Shutdown");
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to read current running state for ServiceAssembly: " + this.getName()), (Throwable)e);
        }
        return null;
    }

    public synchronized void restore() throws Exception {
        String state = this.getRunningStateFromStore();
        if ("Started".equals(state)) {
            this.start(false);
        } else {
            this.stop(false, true);
            if ("Shutdown".equals(state)) {
                this.shutDown(false);
            }
        }
    }

    public ServiceUnitLifeCycle[] getDeployedSUs() {
        return this.sus;
    }

    protected void startConnections() throws JBIException {
        if (this.serviceAssembly.getConnections() == null || this.serviceAssembly.getConnections().getConnections() == null) {
            return;
        }
        Connection[] connections = this.serviceAssembly.getConnections().getConnections();
        for (int i = 0; i < connections.length; ++i) {
            if (connections[i].getConsumer().getInterfaceName() != null) {
                QName fromItf = connections[i].getConsumer().getInterfaceName();
                QName toSvc = connections[i].getProvider().getServiceName();
                String toEp = connections[i].getProvider().getEndpointName();
                this.registry.registerInterfaceConnection(fromItf, toSvc, toEp);
                continue;
            }
            QName fromSvc = connections[i].getConsumer().getServiceName();
            String fromEp = connections[i].getConsumer().getEndpointName();
            QName toSvc = connections[i].getProvider().getServiceName();
            String toEp = connections[i].getProvider().getEndpointName();
            String link = this.getLinkType(fromSvc, fromEp);
            this.registry.registerEndpointConnection(fromSvc, fromEp, toSvc, toEp, link);
        }
    }

    protected String getLinkType(QName svc, String ep) {
        for (int i = 0; i < this.sus.length; ++i) {
            Services s = this.sus[i].getServices();
            if (s == null || s.getConsumes() == null) continue;
            Consumes[] consumes = s.getConsumes();
            for (int j = 0; j < consumes.length; ++j) {
                if (!svc.equals(consumes[j].getServiceName()) || !ep.equals(consumes[j].getEndpointName())) continue;
                return consumes[j].getLinkType();
            }
        }
        return null;
    }

    protected void stopConnections() {
        if (this.serviceAssembly.getConnections() == null || this.serviceAssembly.getConnections().getConnections() == null) {
            return;
        }
        Connection[] connections = this.serviceAssembly.getConnections().getConnections();
        for (int i = 0; i < connections.length; ++i) {
            if (connections[i].getConsumer().getInterfaceName() != null) {
                QName fromItf = connections[i].getConsumer().getInterfaceName();
                this.registry.unregisterInterfaceConnection(fromItf);
                continue;
            }
            QName fromSvc = connections[i].getConsumer().getServiceName();
            String fromEp = connections[i].getConsumer().getEndpointName();
            this.registry.unregisterEndpointConnection(fromSvc, fromEp);
        }
    }

    protected Element getComponentFailure(Exception exception, String task, String component) {
        Element result = null;
        String resultMsg = exception.getMessage();
        try {
            Document doc = this.parse(resultMsg);
            result = this.getElement(doc, "component-task-result");
        }
        catch (Exception e) {
            log.warn((Object)"Could not parse result exception", (Throwable)e);
        }
        if (result == null) {
            result = ManagementSupport.createComponentFailure(task, component, "Unable to parse result string", exception);
        }
        return result;
    }

    protected Document parse(String result) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new InputSource(new StringReader(result)));
    }

    protected Element getElement(Document doc, String name) {
        NodeList l = doc.getElementsByTagNameNS("http://java.sun.com/xml/ns/jbi/management-message", name);
        Element e = (Element)l.item(0);
        return e;
    }

    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "currentState", "current state of the assembly");
        helper.addAttribute(this.getObjectToManage(), "name", "name of the assembly");
        helper.addAttribute(this.getObjectToManage(), "description", "description of the assembly");
        helper.addAttribute(this.getObjectToManage(), "serviceUnits", "list of service units contained in this assembly");
        return helper.getAttributeInfos();
    }

    public MBeanOperationInfo[] getOperationInfos() throws JMException {
        OperationInfoHelper helper = new OperationInfoHelper();
        helper.addOperation(this.getObjectToManage(), "start", "start the assembly");
        helper.addOperation(this.getObjectToManage(), "stop", "stop the assembly");
        helper.addOperation(this.getObjectToManage(), "shutDown", "shutdown the assembly");
        helper.addOperation(this.getObjectToManage(), "getDescriptor", "retrieve the jbi descriptor for this assembly");
        return helper.getOperationInfos();
    }

    public Object getObjectToManage() {
        return this;
    }

    public String getType() {
        return "ServiceAssembly";
    }

    public String getSubType() {
        return null;
    }

    public void setPropertyChangeListener(PropertyChangeListener listener) {
        this.listener = listener;
    }

    protected void firePropertyChanged(String name, Object oldValue, Object newValue) {
        PropertyChangeListener l = this.listener;
        if (l != null) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, name, oldValue, newValue);
            l.propertyChange(event);
        }
    }

    public ObjectName[] getServiceUnits() {
        ObjectName[] names = new ObjectName[this.sus.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.registry.getContainer().getManagementContext().createObjectName(this.sus[i]);
        }
        return names;
    }

    public ServiceAssemblyEnvironment getEnvironment() {
        return this.env;
    }

    protected void fireEvent(int type) {
        ServiceAssemblyEvent event = new ServiceAssemblyEvent(this, type);
        ServiceAssemblyListener[] listeners = (ServiceAssemblyListener[])this.registry.getContainer().getListeners(ServiceAssemblyListener.class);
        block5: for (int i = 0; i < listeners.length; ++i) {
            switch (type) {
                case 1: {
                    listeners[i].assemblyStarted(event);
                    continue block5;
                }
                case 2: {
                    listeners[i].assemblyStopped(event);
                    continue block5;
                }
                case 3: {
                    listeners[i].assemblyShutDown(event);
                }
            }
        }
    }
}

