/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.container.ServiceAssemblyEnvironment;
import org.apache.servicemix.jbi.deployment.ServiceAssembly;
import org.apache.servicemix.jbi.deployment.ServiceUnit;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.framework.ServiceAssemblyLifeCycle;
import org.apache.servicemix.jbi.framework.ServiceAssemblyMBean;
import org.apache.servicemix.jbi.framework.ServiceUnitLifeCycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceAssemblyRegistry {
    private static final Log log = LogFactory.getLog(ServiceAssemblyRegistry.class);
    private Map<String, ServiceAssemblyLifeCycle> serviceAssemblies = new ConcurrentHashMap<String, ServiceAssemblyLifeCycle>();
    private Registry registry;

    public ServiceAssemblyRegistry(Registry registry) {
        this.registry = registry;
    }

    public void start() {
    }

    public void stop() {
    }

    public void shutDown() {
    }

    public ServiceAssemblyLifeCycle register(ServiceAssembly sa, String[] suKeys, ServiceAssemblyEnvironment env) throws DeploymentException {
        String saName = sa.getIdentification().getName();
        if (!this.serviceAssemblies.containsKey(saName)) {
            ServiceAssemblyLifeCycle salc = new ServiceAssemblyLifeCycle(sa, env, this.registry);
            ArrayList<ServiceUnitLifeCycle> sus = new ArrayList<ServiceUnitLifeCycle>();
            for (int i = 0; i < suKeys.length; ++i) {
                sus.add(this.registry.getServiceUnit(suKeys[i]));
            }
            salc.setServiceUnits(sus.toArray(new ServiceUnitLifeCycle[sus.size()]));
            this.serviceAssemblies.put(saName, salc);
            try {
                ObjectName objectName = this.registry.getContainer().getManagementContext().createObjectName(salc);
                this.registry.getContainer().getManagementContext().registerMBean(objectName, salc, ServiceAssemblyMBean.class);
            }
            catch (JMException e) {
                log.error((Object)"Could not register MBean for service assembly", (Throwable)e);
            }
            return salc;
        }
        return null;
    }

    public ServiceAssemblyLifeCycle register(ServiceAssembly sa, ServiceAssemblyEnvironment env) throws DeploymentException {
        ArrayList<String> sus = new ArrayList<String>();
        if (sa.getServiceUnits() != null) {
            for (int i = 0; i < sa.getServiceUnits().length; ++i) {
                String suKey = this.registry.registerServiceUnit(sa.getServiceUnits()[i], sa.getIdentification().getName(), env.getServiceUnitDirectory(sa.getServiceUnits()[i].getTarget().getComponentName(), sa.getServiceUnits()[i].getIdentification().getName()));
                sus.add(suKey);
            }
        }
        return this.register(sa, sus.toArray(new String[sus.size()]), env);
    }

    public boolean unregister(String name) {
        ServiceAssemblyLifeCycle salc = this.serviceAssemblies.remove(name);
        if (salc != null) {
            try {
                ServiceUnitLifeCycle[] sus = salc.getDeployedSUs();
                if (sus != null) {
                    for (int i = 0; i < sus.length; ++i) {
                        this.registry.unregisterServiceUnit(sus[i].getKey());
                    }
                }
                this.registry.getContainer().getManagementContext().unregisterMBean(salc);
            }
            catch (JBIException e) {
                log.error((Object)"Unable to unregister MBean for service assembly", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    public ServiceAssemblyLifeCycle getServiceAssembly(String saName) {
        return this.serviceAssemblies.get(saName);
    }

    public String[] getDeployedServiceAssemblies() {
        String[] result = null;
        Set<String> keys = this.serviceAssemblies.keySet();
        result = new String[keys.size()];
        keys.toArray(result);
        return result;
    }

    public String[] getDeployedServiceAssembliesForComponent(String componentName) {
        String[] result = null;
        HashSet<String> tmpList = new HashSet<String>();
        for (ServiceAssemblyLifeCycle salc : this.serviceAssemblies.values()) {
            ServiceUnit[] sus = salc.getServiceAssembly().getServiceUnits();
            if (sus == null) continue;
            for (int i = 0; i < sus.length; ++i) {
                if (!sus[i].getTarget().getComponentName().equals(componentName)) continue;
                tmpList.add(salc.getServiceAssembly().getIdentification().getName());
            }
        }
        result = new String[tmpList.size()];
        tmpList.toArray(result);
        return result;
    }

    public String[] getComponentsForDeployedServiceAssembly(String saName) {
        ServiceUnit[] sus;
        String[] result = null;
        HashSet<String> tmpList = new HashSet<String>();
        ServiceAssemblyLifeCycle sa = this.getServiceAssembly(saName);
        if (sa != null && (sus = sa.getServiceAssembly().getServiceUnits()) != null) {
            for (int i = 0; i < sus.length; ++i) {
                tmpList.add(sus[i].getTarget().getComponentName());
            }
        }
        result = new String[tmpList.size()];
        tmpList.toArray(result);
        return result;
    }

    public boolean isDeployedServiceUnit(String componentName, String suName) {
        boolean result = false;
        block0: for (ServiceAssemblyLifeCycle salc : this.serviceAssemblies.values()) {
            ServiceUnit[] sus = salc.getServiceAssembly().getServiceUnits();
            if (sus == null) continue;
            for (int i = 0; i < sus.length; ++i) {
                if (!sus[i].getTarget().getComponentName().equals(componentName) || !sus[i].getIdentification().getName().equals(suName)) continue;
                result = true;
                continue block0;
            }
        }
        return result;
    }

    public Collection<ServiceAssemblyLifeCycle> getServiceAssemblies() {
        return this.serviceAssemblies.values();
    }
}

