/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.deployment.Provides;
import org.apache.servicemix.jbi.deployment.Services;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.framework.ServiceUnitLifeCycle;
import org.apache.servicemix.jbi.framework.support.EndpointProcessor;
import org.apache.servicemix.jbi.servicedesc.InternalEndpoint;

public class SUDescriptorProcessor
implements EndpointProcessor {
    private static final Log logger = LogFactory.getLog(SUDescriptorProcessor.class);
    private Registry registry;

    public void init(Registry registry) {
        this.registry = registry;
    }

    public void process(InternalEndpoint serviceEndpoint) {
        ServiceUnitLifeCycle[] sus = this.registry.getDeployedServiceUnits(serviceEndpoint.getComponentNameSpace().getName());
        for (int i = 0; i < sus.length; ++i) {
            Provides[] provides;
            Services services = sus[i].getServices();
            if (services == null || (provides = services.getProvides()) == null) continue;
            for (int j = 0; j < provides.length; ++j) {
                if (provides[j].getInterfaceName() == null || !serviceEndpoint.getServiceName().equals(provides[j].getServiceName()) || !serviceEndpoint.getEndpointName().equals(provides[j].getEndpointName())) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Endpoint " + serviceEndpoint + " is provided by SU " + sus[i].getName()));
                    logger.debug((Object)("Endpoint " + serviceEndpoint + " implements interface " + provides[j].getInterfaceName()));
                }
                serviceEndpoint.addInterface(provides[j].getInterfaceName());
            }
        }
    }
}

