/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.jaxp;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.servicemix.jbi.jaxp.BytesSource;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SourceTransformer {
    public static final String DEFAULT_CHARSET_PROPERTY = "org.apache.servicemix.default.charset";
    private DocumentBuilderFactory documentBuilderFactory;
    private TransformerFactory transformerFactory;
    public static String defaultCharset = System.getProperty("org.apache.servicemix.default.charset", "UTF-8");
    private static final Class dom2SaxClass;

    public SourceTransformer() {
    }

    public SourceTransformer(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public void toResult(Source source, Result result) throws TransformerException {
        if (source == null) {
            return;
        }
        Transformer transformer = this.createTransfomer();
        if (transformer == null) {
            throw new TransformerException("Could not create a transformer - JAXP is misconfigured!");
        }
        transformer.setOutputProperty("encoding", defaultCharset);
        transformer.transform(source, result);
    }

    public String toString(Source source) throws TransformerException {
        if (source == null) {
            return null;
        }
        if (source instanceof StringSource) {
            return ((StringSource)source).getText();
        }
        if (source instanceof BytesSource) {
            return new String(((BytesSource)source).getData());
        }
        StringWriter buffer = new StringWriter();
        this.toResult(source, new StreamResult(buffer));
        return buffer.toString();
    }

    public String toString(Node node) throws TransformerException {
        return this.toString(new DOMSource(node));
    }

    public String contentToString(NormalizedMessage message) throws MessagingException, TransformerException, ParserConfigurationException, IOException, SAXException {
        return this.toString(message.getContent());
    }

    public DOMSource toDOMSource(Source source) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        if (source instanceof DOMSource) {
            return (DOMSource)source;
        }
        if (source instanceof SAXSource) {
            return this.toDOMSourceFromSAX((SAXSource)source);
        }
        if (source instanceof StreamSource) {
            return this.toDOMSourceFromStream((StreamSource)source);
        }
        return null;
    }

    public Source toDOMSource(NormalizedMessage message) throws MessagingException, TransformerException, ParserConfigurationException, IOException, SAXException {
        Node node = this.toDOMNode(message);
        return new DOMSource(node);
    }

    public SAXSource toSAXSource(Source source) throws IOException, SAXException, TransformerException {
        if (source instanceof SAXSource) {
            return (SAXSource)source;
        }
        if (source instanceof DOMSource) {
            return this.toSAXSourceFromDOM((DOMSource)source);
        }
        if (source instanceof StreamSource) {
            return this.toSAXSourceFromStream((StreamSource)source);
        }
        return null;
    }

    public StreamSource toStreamSource(Source source) throws TransformerException {
        if (source instanceof StreamSource) {
            return (StreamSource)source;
        }
        if (source instanceof DOMSource) {
            return this.toStreamSourceFromDOM((DOMSource)source);
        }
        if (source instanceof SAXSource) {
            return this.toStreamSourceFromSAX((SAXSource)source);
        }
        return null;
    }

    public StreamSource toStreamSourceFromSAX(SAXSource source) throws TransformerException {
        InputSource inputSource = source.getInputSource();
        if (inputSource != null) {
            if (inputSource.getCharacterStream() != null) {
                return new StreamSource(inputSource.getCharacterStream());
            }
            if (inputSource.getByteStream() != null) {
                return new StreamSource(inputSource.getByteStream());
            }
        }
        String result = this.toString(source);
        return new StringSource(result);
    }

    public StreamSource toStreamSourceFromDOM(DOMSource source) throws TransformerException {
        String result = this.toString(source);
        return new StringSource(result);
    }

    public SAXSource toSAXSourceFromStream(StreamSource source) {
        InputSource inputSource = source.getReader() != null ? new InputSource(source.getReader()) : new InputSource(source.getInputStream());
        inputSource.setSystemId(source.getSystemId());
        inputSource.setPublicId(source.getPublicId());
        return new SAXSource(inputSource);
    }

    public Reader toReaderFromSource(Source src) throws TransformerException {
        StreamSource stSrc = this.toStreamSource(src);
        Reader r = stSrc.getReader();
        if (r == null) {
            r = new InputStreamReader(stSrc.getInputStream());
        }
        return r;
    }

    public DOMSource toDOMSourceFromStream(StreamSource source) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder builder = this.createDocumentBuilder();
        String systemId = source.getSystemId();
        Document document = null;
        Reader reader = source.getReader();
        if (reader != null) {
            document = builder.parse(new InputSource(reader));
        } else {
            InputStream inputStream = source.getInputStream();
            if (inputStream != null) {
                InputSource inputsource = new InputSource(inputStream);
                inputsource.setSystemId(systemId);
                document = builder.parse(inputsource);
            } else {
                throw new IOException("No input stream or reader available");
            }
        }
        return new DOMSource(document, systemId);
    }

    public SAXSource toSAXSourceFromDOM(DOMSource source) throws TransformerException {
        if (dom2SaxClass != null) {
            try {
                Constructor cns = dom2SaxClass.getConstructor(Node.class);
                XMLReader converter = (XMLReader)cns.newInstance(source.getNode());
                return new SAXSource(converter, new InputSource());
            }
            catch (Exception e) {
                throw new TransformerException(e);
            }
        }
        String str = this.toString(source);
        StringReader reader = new StringReader(str);
        return new SAXSource(new InputSource(reader));
    }

    public DOMSource toDOMSourceFromSAX(SAXSource source) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        return new DOMSource(this.toDOMNodeFromSAX(source));
    }

    public Node toDOMNodeFromSAX(SAXSource source) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        DOMResult result = new DOMResult();
        this.toResult(source, result);
        return result.getNode();
    }

    public Node toDOMNode(Source source) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        DOMSource domSrc = this.toDOMSource(source);
        return domSrc != null ? domSrc.getNode() : null;
    }

    public Node toDOMNode(NormalizedMessage message) throws MessagingException, TransformerException, ParserConfigurationException, IOException, SAXException {
        Source content = message.getContent();
        Node node = this.toDOMNode(content);
        return node;
    }

    public Element toDOMElement(NormalizedMessage message) throws MessagingException, TransformerException, ParserConfigurationException, IOException, SAXException {
        Node node = this.toDOMNode(message);
        return this.toDOMElement(node);
    }

    public Element toDOMElement(Source source) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        Node node = this.toDOMNode(source);
        return this.toDOMElement(node);
    }

    public Element toDOMElement(Node node) throws TransformerException {
        if (node instanceof Document) {
            return ((Document)node).getDocumentElement();
        }
        if (node instanceof Element) {
            return (Element)node;
        }
        throw new TransformerException("Unable to convert DOM node to an Element");
    }

    public Document toDOMDocument(NormalizedMessage message) throws MessagingException, TransformerException, ParserConfigurationException, IOException, SAXException {
        Node node = this.toDOMNode(message);
        return this.toDOMDocument(node);
    }

    public Document toDOMDocument(Source source) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        Node node = this.toDOMNode(source);
        return this.toDOMDocument(node);
    }

    public Document toDOMDocument(Node node) throws ParserConfigurationException, TransformerException {
        if (node instanceof Document) {
            return (Document)node;
        }
        if (node instanceof Element) {
            Element elem = (Element)node;
            if (elem.getOwnerDocument().getDocumentElement() == elem) {
                return elem.getOwnerDocument();
            }
            Document doc = this.createDocument();
            doc.appendChild(doc.importNode(node, true));
            return doc;
        }
        throw new TransformerException("Unable to convert DOM node to a Document");
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        if (this.documentBuilderFactory == null) {
            this.documentBuilderFactory = this.createDocumentBuilderFactory();
        }
        return this.documentBuilderFactory;
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        return factory;
    }

    public DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = this.getDocumentBuilderFactory();
        return factory.newDocumentBuilder();
    }

    public Document createDocument() throws ParserConfigurationException {
        DocumentBuilder builder = this.createDocumentBuilder();
        return builder.newDocument();
    }

    public TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            this.transformerFactory = this.createTransformerFactory();
        }
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public Transformer createTransfomer() throws TransformerConfigurationException {
        TransformerFactory factory = this.getTransformerFactory();
        return factory.newTransformer();
    }

    public TransformerFactory createTransformerFactory() {
        TransformerFactory answer = TransformerFactory.newInstance();
        return answer;
    }

    static {
        Class<?> cl = null;
        try {
            cl = Class.forName("org.apache.xalan.xsltc.trax.DOM2SAX");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        dom2SaxClass = cl;
    }
}

