/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.jmx;

import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.servicemix.jbi.security.auth.AuthenticationService;
import org.apache.servicemix.jbi.security.auth.impl.JAASAuthenticationService;

public class JaasAuthenticator
implements JMXAuthenticator {
    private String domain = "servicemix-domain";
    private AuthenticationService authenticationService = new JAASAuthenticationService();

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Subject authenticate(Object credentials) throws SecurityException {
        if (!(credentials instanceof String[])) {
            throw new IllegalArgumentException("Expected String[2], got " + (credentials != null ? credentials.getClass().getName() : null));
        }
        String[] params = (String[])credentials;
        if (params.length != 2) {
            throw new IllegalArgumentException("Expected String[2] but length was " + params.length);
        }
        Subject subject = new Subject();
        try {
            this.authenticationService.authenticate(subject, this.domain, params[0], params[1]);
        }
        catch (LoginException e) {
            throw new SecurityException("Authentication failed", e);
        }
        catch (Exception e) {
            throw new SecurityException("Error occured while authenticating", e);
        }
        return subject;
    }
}

