/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.logging;

import java.net.URL;
import java.net.URLConnection;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class LogTask
extends TimerTask {
    private static Logger logger = Logger.getLogger(LogTask.class);
    private URL url;
    private long lastConfigured = -1L;

    public LogTask(URL url) {
        this.url = url;
    }

    public void run() {
        this.reconfigure();
    }

    public void reconfigure() {
        try {
            URLConnection conn = this.url.openConnection();
            conn.connect();
            long lastModified = conn.getLastModified();
            boolean xml = "application/xml".equals(conn.getContentType());
            conn.getInputStream().close();
            if (this.lastConfigured < lastModified && this.url != null && xml) {
                DOMConfigurator.configure((URL)this.url);
                this.lastConfigured = System.currentTimeMillis();
                logger.info((Object)("Logging system reconfigured using file: " + this.url.toString()));
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }
}

