/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.monitoring;

import org.apache.servicemix.jbi.monitoring.stats.CountStatisticImpl;
import org.apache.servicemix.jbi.monitoring.stats.StatsImpl;
import org.apache.servicemix.jbi.monitoring.stats.TimeStatisticImpl;
import org.apache.servicemix.jbi.util.IndentPrinter;

public class MessagingStats
extends StatsImpl {
    private String name;
    protected CountStatisticImpl inboundExchanges;
    protected CountStatisticImpl outboundExchanges;
    protected TimeStatisticImpl inboundExchangeRate;
    protected TimeStatisticImpl outboundExchangeRate;

    public MessagingStats(String name) {
        this.name = name;
        this.inboundExchanges = new CountStatisticImpl("inboundExchanges", "Number of Inbound MessageExchanges");
        this.outboundExchanges = new CountStatisticImpl("outboundExchanges", "Number of Outbound MessageExchanges");
        this.inboundExchangeRate = new TimeStatisticImpl("inboundExchangeRate", "time taken to process an Exchange");
        this.outboundExchangeRate = new TimeStatisticImpl("outboundExchangeRate", "time taken to send an Exchange");
        this.addStatistic("inboundExchanges", this.inboundExchanges);
        this.addStatistic("outboundExchanges", this.outboundExchanges);
        this.addStatistic("inboundExchangeRate", this.inboundExchangeRate);
        this.addStatistic("outboundExchangeRate", this.outboundExchangeRate);
    }

    public MessagingStats(String name, MessagingStats parent) {
        this.name = name;
        this.inboundExchanges = new CountStatisticImpl(parent.inboundExchanges, "inboundExchanges", "Number of Inbound MessageExchanges");
        this.outboundExchanges = new CountStatisticImpl(parent.outboundExchanges, "outboundExchanges", "Number of Outbound MessageExchanges");
        this.inboundExchangeRate = new TimeStatisticImpl(parent.inboundExchangeRate, "inboundExchangeRate", "time taken to process an Exchange");
        this.outboundExchangeRate = new TimeStatisticImpl(parent.outboundExchangeRate, "outboundExchangeRate", "time taken to send an Exchange");
        this.addStatistic("inboundExchanges", this.inboundExchanges);
        this.addStatistic("outboundExchanges", this.outboundExchanges);
        this.addStatistic("inboundExchangeRate", this.inboundExchangeRate);
        this.addStatistic("outboundExchangeRate", this.outboundExchangeRate);
    }

    public String getName() {
        return this.name;
    }

    public TimeStatisticImpl getInboundExchangeRate() {
        return this.inboundExchangeRate;
    }

    public CountStatisticImpl getInboundExchanges() {
        return this.inboundExchanges;
    }

    public TimeStatisticImpl getOutboundExchangeRate() {
        return this.outboundExchangeRate;
    }

    public CountStatisticImpl getOutboundExchanges() {
        return this.outboundExchanges;
    }

    public synchronized void reset() {
        super.reset();
        this.inboundExchanges.reset();
        this.outboundExchanges.reset();
        this.inboundExchangeRate.reset();
        this.outboundExchangeRate.reset();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Statistics: ");
        buffer.append(this.name);
        buffer.append(" { ");
        buffer.append(this.inboundExchanges);
        buffer.append(" ");
        buffer.append(this.inboundExchangeRate);
        buffer.append(" ");
        buffer.append(this.outboundExchanges);
        buffer.append(" ");
        buffer.append(this.outboundExchangeRate);
        buffer.append(" }");
        return buffer.toString();
    }

    public void dump(IndentPrinter out) {
        out.printIndent();
        out.println("Statistics: ");
        out.print(this.name);
        out.println(" {");
        out.incrementIndent();
        out.println(this.inboundExchanges);
        out.printIndent();
        out.println(this.inboundExchangeRate);
        out.printIndent();
        out.println(this.outboundExchanges);
        out.printIndent();
        out.decrementIndent();
        out.printIndent();
        out.println("}");
    }
}

