/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.nmr;

import java.util.ArrayList;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.JMException;
import javax.management.MBeanOperationInfo;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.container.ActivationSpec;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.framework.ComponentContextImpl;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.framework.ComponentNameSpace;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.management.BaseSystemService;
import org.apache.servicemix.jbi.management.ManagementContext;
import org.apache.servicemix.jbi.management.OperationInfoHelper;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.nmr.Broker;
import org.apache.servicemix.jbi.nmr.BrokerMBean;
import org.apache.servicemix.jbi.nmr.SubscriptionManager;
import org.apache.servicemix.jbi.nmr.flow.DefaultFlowChooser;
import org.apache.servicemix.jbi.nmr.flow.Flow;
import org.apache.servicemix.jbi.nmr.flow.FlowChooser;
import org.apache.servicemix.jbi.nmr.flow.FlowProvider;
import org.apache.servicemix.jbi.resolver.ConsumerComponentEndpointFilter;
import org.apache.servicemix.jbi.resolver.EndpointChooser;
import org.apache.servicemix.jbi.resolver.EndpointFilter;
import org.apache.servicemix.jbi.resolver.EndpointResolver;
import org.apache.servicemix.jbi.resolver.FirstChoicePolicy;
import org.apache.servicemix.jbi.resolver.ProducerComponentEndpointFilter;
import org.apache.servicemix.jbi.servicedesc.AbstractServiceEndpoint;
import org.apache.servicemix.jbi.servicedesc.ExternalEndpoint;
import org.apache.servicemix.jbi.servicedesc.InternalEndpoint;
import org.apache.servicemix.jbi.servicedesc.LinkedEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBroker
extends BaseSystemService
implements Broker {
    private Registry registry;
    private String flowNames = "seda";
    private String subscriptionFlowName = null;
    private Flow[] flows;
    private static final Log log = LogFactory.getLog(DefaultBroker.class);
    private EndpointChooser defaultServiceChooser = new FirstChoicePolicy();
    private EndpointChooser defaultInterfaceChooser = new FirstChoicePolicy();
    private SubscriptionManager subscriptionManager = new SubscriptionManager();
    private FlowChooser defaultFlowChooser = new DefaultFlowChooser();

    @Override
    public String getDescription() {
        return "Normalized Message Router";
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public void setSubscriptionManager(SubscriptionManager subscriptionManager) {
        this.subscriptionManager = subscriptionManager;
    }

    @Override
    public void init(JBIContainer container) throws JBIException {
        super.init(container);
        this.registry = container.getRegistry();
        if (this.flows == null) {
            String[] names = this.flowNames.split(",");
            this.flows = new Flow[names.length];
            for (int i = 0; i < names.length; ++i) {
                this.flows[i] = FlowProvider.getFlow(names[i]);
                this.flows[i].init(this);
            }
        } else {
            for (int i = 0; i < this.flows.length; ++i) {
                this.flows[i].init(this);
            }
        }
        this.subscriptionManager.init(this, this.registry);
    }

    @Override
    protected Class<BrokerMBean> getServiceMBean() {
        return BrokerMBean.class;
    }

    public String getContainerName() {
        return this.container.getName();
    }

    public ManagementContext getManagementContext() {
        return this.container.getManagementContext();
    }

    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public void start() throws JBIException {
        for (int i = 0; i < this.flows.length; ++i) {
            this.flows[i].start();
        }
        super.start();
    }

    @Override
    public void stop() throws JBIException {
        for (int i = 0; i < this.flows.length; ++i) {
            this.flows[i].stop();
        }
        super.stop();
    }

    @Override
    public void shutDown() throws JBIException {
        this.stop();
        for (int i = 0; i < this.flows.length; ++i) {
            this.flows[i].shutDown();
        }
        this.container.deactivateComponent("#SubscriptionManager#");
        super.shutDown();
        this.container.getManagementContext().unregisterMBean(this);
    }

    public String getFlowNames() {
        return this.flowNames;
    }

    public void setFlowNames(String flowNames) {
        this.flowNames = flowNames;
    }

    public String getSubscriptionFlowName() {
        return this.subscriptionFlowName;
    }

    public void setSubscriptionFlowName(String subscriptionFlowName) {
        this.subscriptionFlowName = subscriptionFlowName;
    }

    public void setFlows(Flow[] flows) {
        this.flows = flows;
    }

    public Flow[] getFlows() {
        return this.flows;
    }

    @Override
    public void suspend() {
        for (int i = 0; i < this.flows.length; ++i) {
            this.flows[i].suspend();
        }
    }

    @Override
    public void resume() {
        for (int i = 0; i < this.flows.length; ++i) {
            this.flows[i].resume();
        }
    }

    @Override
    public void sendExchangePacket(MessageExchange me) throws JBIException {
        MessageExchangeImpl exchange = (MessageExchangeImpl)me;
        if (exchange.getRole() == MessageExchange.Role.PROVIDER && exchange.getDestinationId() == null) {
            this.resolveAddress(exchange);
        }
        boolean foundRoute = false;
        if (exchange.getEndpoint() != null || exchange.getRole() == MessageExchange.Role.CONSUMER) {
            foundRoute = true;
            Flow flow = this.defaultFlowChooser.chooseFlow(this.flows, exchange);
            if (flow == null) {
                throw new MessagingException("Unable to choose a flow for exchange: " + exchange);
            }
            flow.send(exchange);
        }
        if (exchange.getRole() == MessageExchange.Role.PROVIDER) {
            this.getSubscriptionManager().dispatchToSubscribers(exchange);
        }
        if (!foundRoute) {
            boolean throwException = true;
            ActivationSpec activationSpec = exchange.getActivationSpec();
            if (activationSpec != null) {
                throwException = activationSpec.isFailIfNoDestinationEndpoint();
            }
            if (throwException) {
                throw new MessagingException("Could not find route for exchange: " + exchange + " for service: " + exchange.getService() + " and interface: " + exchange.getInterfaceName());
            }
            if (exchange.getMirror().getSyncState() == 1) {
                exchange.handleAccept();
                ComponentContextImpl ctx = (ComponentContextImpl)this.getSubscriptionManager().getContext();
                exchange.setDestinationId(ctx.getComponentNameSpace());
                this.getSubscriptionManager().done(exchange);
            }
        }
    }

    protected void resolveAddress(MessageExchangeImpl exchange) throws JBIException {
        ServiceEndpoint theEndpoint = exchange.getEndpoint();
        if (theEndpoint != null) {
            if (theEndpoint instanceof ExternalEndpoint) {
                throw new JBIException("External endpoints can not be used for routing: should be an internal or dynamic endpoint.");
            }
            if (!(theEndpoint instanceof AbstractServiceEndpoint)) {
                throw new JBIException("Component-specific endpoints can not be used for routing: should be an internal or dynamic endpoint.");
            }
        }
        if (theEndpoint instanceof LinkedEndpoint) {
            String epName;
            QName svcName = ((LinkedEndpoint)theEndpoint).getToService();
            ServiceEndpoint ep = this.registry.getInternalEndpoint(svcName, epName = ((LinkedEndpoint)theEndpoint).getToEndpoint());
            if (ep == null) {
                throw new JBIException("Could not resolve linked endpoint: " + theEndpoint);
            }
            theEndpoint = ep;
        }
        ComponentContextImpl context = exchange.getSourceContext();
        if (theEndpoint == null) {
            EndpointResolver destinationResolver;
            ActivationSpec activationSpec;
            ServiceEndpoint[] endpoints;
            QName serviceName = exchange.getService();
            QName interfaceName = exchange.getInterfaceName();
            if (serviceName != null) {
                endpoints = this.registry.getEndpointsForService(serviceName);
                endpoints = this.getMatchingEndpoints(endpoints, exchange);
                theEndpoint = this.getServiceChooser(exchange).chooseEndpoint(endpoints, context, exchange);
                if (theEndpoint == null) {
                    log.warn((Object)("ServiceName (" + serviceName + ") specified for routing, but can't find it registered"));
                }
            }
            if (theEndpoint == null && interfaceName != null) {
                endpoints = this.registry.getEndpointsForInterface(interfaceName);
                endpoints = this.getMatchingEndpoints(endpoints, exchange);
                theEndpoint = (InternalEndpoint)this.getInterfaceChooser(exchange).chooseEndpoint(endpoints, context, exchange);
                if (theEndpoint == null) {
                    log.warn((Object)("InterfaceName (" + interfaceName + ") specified for routing, but can't find any matching components"));
                }
            }
            if (theEndpoint == null && (activationSpec = exchange.getActivationSpec()) != null && (destinationResolver = activationSpec.getDestinationResolver()) != null) {
                try {
                    EndpointFilter filter = this.createEndpointFilter(context, exchange);
                    theEndpoint = (InternalEndpoint)destinationResolver.resolveEndpoint(context, exchange, filter);
                }
                catch (JBIException e) {
                    throw new MessagingException("Failed to resolve endpoint: " + (Object)((Object)e), (Throwable)e);
                }
            }
        }
        if (theEndpoint != null) {
            exchange.setEndpoint(theEndpoint);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Routing exchange " + exchange + " to: " + theEndpoint));
        }
    }

    protected ServiceEndpoint[] getMatchingEndpoints(ServiceEndpoint[] endpoints, MessageExchangeImpl exchange) {
        ArrayList<ServiceEndpoint> filtered = new ArrayList<ServiceEndpoint>();
        ComponentMBeanImpl consumer = this.getRegistry().getComponent(exchange.getSourceId());
        for (int i = 0; i < endpoints.length; ++i) {
            ComponentMBeanImpl provider;
            ComponentNameSpace id = ((InternalEndpoint)endpoints[i]).getComponentNameSpace();
            if (id != null && (provider = this.getRegistry().getComponent(id)) != null && (!consumer.getComponent().isExchangeWithProviderOkay(endpoints[i], (MessageExchange)exchange) || !provider.getComponent().isExchangeWithConsumerOkay(endpoints[i], (MessageExchange)exchange))) continue;
            filtered.add(endpoints[i]);
        }
        return filtered.toArray(new ServiceEndpoint[filtered.size()]);
    }

    public EndpointChooser getDefaultInterfaceChooser() {
        return this.defaultInterfaceChooser;
    }

    public void setDefaultInterfaceChooser(EndpointChooser defaultInterfaceChooser) {
        this.defaultInterfaceChooser = defaultInterfaceChooser;
    }

    public EndpointChooser getDefaultServiceChooser() {
        return this.defaultServiceChooser;
    }

    public void setDefaultServiceChooser(EndpointChooser defaultServiceChooser) {
        this.defaultServiceChooser = defaultServiceChooser;
    }

    public FlowChooser getDefaultFlowChooser() {
        return this.defaultFlowChooser;
    }

    public void setDefaultFlowChooser(FlowChooser defaultFlowChooser) {
        this.defaultFlowChooser = defaultFlowChooser;
    }

    protected EndpointChooser getServiceChooser(MessageExchangeImpl exchange) {
        EndpointChooser chooser = null;
        ActivationSpec activationSpec = exchange.getActivationSpec();
        if (activationSpec != null) {
            chooser = activationSpec.getServiceChooser();
        }
        if (chooser == null) {
            chooser = this.defaultServiceChooser;
        }
        return chooser;
    }

    protected EndpointChooser getInterfaceChooser(MessageExchangeImpl exchange) {
        EndpointChooser chooser = null;
        ActivationSpec activationSpec = exchange.getActivationSpec();
        if (activationSpec != null) {
            chooser = activationSpec.getInterfaceChooser();
        }
        if (chooser == null) {
            chooser = this.defaultInterfaceChooser;
        }
        return chooser;
    }

    protected EndpointFilter createEndpointFilter(ComponentContextImpl context, MessageExchangeImpl exchange) {
        Component component = context.getComponent();
        if (exchange.getRole() == MessageExchange.Role.PROVIDER) {
            return new ConsumerComponentEndpointFilter(component);
        }
        return new ProducerComponentEndpointFilter(component);
    }

    @Override
    public MBeanOperationInfo[] getOperationInfos() throws JMException {
        OperationInfoHelper helper = new OperationInfoHelper();
        helper.addOperation(this.getObjectToManage(), "suspend", "suspend the NMR processing");
        helper.addOperation(this.getObjectToManage(), "resume", "resume the NMR processing");
        return OperationInfoHelper.join(super.getOperationInfos(), helper.getOperationInfos());
    }

    @Override
    public JBIContainer getContainer() {
        return this.container;
    }
}

