/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.nmr;

import java.util.List;
import java.util.Set;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.components.util.ComponentSupport;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.nmr.Broker;
import org.apache.servicemix.jbi.servicedesc.InternalEndpoint;

public class SubscriptionManager
extends ComponentSupport
implements MessageExchangeListener {
    public static final String COMPONENT_NAME = "#SubscriptionManager#";
    private Registry registry;
    private String flowName;
    private static Log log = LogFactory.getLog(SubscriptionManager.class);
    private static final String FROM_SUBSCRIPTION_MANAGER = "org.apache.servicemix.jbi.nmr.from_subman";

    public void init(Broker broker, Registry registry) throws JBIException {
        this.registry = registry;
        broker.getContainer().activateComponent((Component)this, COMPONENT_NAME);
    }

    protected boolean dispatchToSubscribers(MessageExchangeImpl exchange) throws JBIException {
        Boolean source = (Boolean)exchange.getProperty(FROM_SUBSCRIPTION_MANAGER);
        if (source == null || !source.booleanValue()) {
            List<InternalEndpoint> list = this.registry.getMatchingSubscriptionEndpoints(exchange);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    InternalEndpoint endpoint = list.get(i);
                    this.dispatchToSubscriber(exchange, endpoint);
                }
            }
            return list != null && !list.isEmpty();
        }
        return false;
    }

    protected void dispatchToSubscriber(MessageExchangeImpl exchange, InternalEndpoint endpoint) throws JBIException {
        Boolean source;
        if (log.isDebugEnabled() && endpoint != null) {
            log.debug((Object)("Subscription Endpoint: " + endpoint.getEndpointName()));
        }
        if ((source = (Boolean)exchange.getProperty(FROM_SUBSCRIPTION_MANAGER)) == null || !source.booleanValue()) {
            DeliveryChannel channel = this.getDeliveryChannel();
            InOnly me = channel.createExchangeFactory().createInOnlyExchange();
            me.setProperty(FROM_SUBSCRIPTION_MANAGER, (Object)Boolean.TRUE);
            NormalizedMessage in = me.createMessage();
            this.getMessageTransformer().transform((MessageExchange)me, exchange.getInMessage(), in);
            me.setInMessage(in);
            me.setEndpoint((ServiceEndpoint)endpoint);
            Set names = exchange.getPropertyNames();
            for (String name : names) {
                me.setProperty(name, exchange.getProperty(name));
            }
            if (Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"))) {
                channel.sendSync((MessageExchange)me);
            } else {
                channel.send((MessageExchange)me);
            }
        }
    }

    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public void onMessageExchange(MessageExchange exchange) throws MessagingException {
    }
}

