/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.nmr.flow.jms;

import java.lang.reflect.Constructor;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.servicemix.jbi.nmr.flow.jms.AbstractJMSFlow;

public class JMSFlowTibco
extends AbstractJMSFlow {
    private static final String TOPIC_NAME_MONITOR_CONSUMER = "$sys.monitor.consumer.*";
    private static final String PROPERTY_NAME_EVENT_CLASS = "event_class";
    private static final String PROPERTY_NAME_TARGET_DEST_NAME = "target_dest_name";
    private static final String PROPERTY_NAME_CONN_CONNID = "conn_connid";
    private static final String EVENT_CLASS_CONSUMER_CREATE = "consumer.create";

    protected ConnectionFactory createConnectionFactoryFromUrl(String jmsURL) {
        try {
            Class<?> connFactoryClass = Class.forName("com.tibco.tibjms.TibjmsConnectionFactory");
            if (jmsURL != null) {
                Constructor<?> cns = connFactoryClass.getConstructor(String.class);
                ConnectionFactory connFactory = (ConnectionFactory)cns.newInstance(jmsURL);
                return connFactory;
            }
            ConnectionFactory connFactory = (ConnectionFactory)connFactoryClass.newInstance();
            return connFactory;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create Tibco connection factory", e);
        }
    }

    public void onConsumerMonitorMessage(Message message) {
        if (!this.started.get()) {
            return;
        }
        try {
            String connectionId = "" + message.getLongProperty(PROPERTY_NAME_CONN_CONNID);
            String targetDestName = message.getStringProperty(PROPERTY_NAME_TARGET_DEST_NAME);
            String eventClass = message.getStringProperty(PROPERTY_NAME_EVENT_CLASS);
            if (this.getBroadcastDestinationName().equals(targetDestName)) {
                if (EVENT_CLASS_CONSUMER_CREATE.equals(eventClass)) {
                    this.addClusterNode(connectionId);
                } else {
                    this.removeClusterNode(connectionId);
                }
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public void startConsumerMonitor() throws JMSException {
        Session broadcastSession = this.connection.createSession(false, 1);
        Topic createTopic = broadcastSession.createTopic(TOPIC_NAME_MONITOR_CONSUMER);
        this.monitorMessageConsumer = broadcastSession.createConsumer((Destination)createTopic);
        this.monitorMessageConsumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                JMSFlowTibco.this.onConsumerMonitorMessage(message);
            }
        });
    }
}

