/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.nmr.flow.seda;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessagingException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.executors.Executor;
import org.apache.servicemix.jbi.framework.ComponentNameSpace;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.BaseLifeCycle;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.nmr.flow.seda.SedaFlow;

public class SedaQueue
extends BaseLifeCycle {
    private static final Log log = LogFactory.getLog(SedaQueue.class);
    protected SedaFlow flow;
    protected ComponentNameSpace name;
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected AtomicBoolean running = new AtomicBoolean(false);
    protected ObjectName objectName;
    protected String subType;
    protected Thread thread;
    protected Executor executor;

    public SedaQueue(ComponentNameSpace name) {
        this.name = name;
    }

    public String getName() {
        return this.name.getName();
    }

    public String getType() {
        return "SedaQueue";
    }

    public ComponentNameSpace getComponentNameSpace() {
        return this.name;
    }

    public String getDescription() {
        return "bounded worker Queue for the NMR";
    }

    public void init(SedaFlow flow) {
        this.flow = flow;
    }

    public int getCapacity() {
        if (this.executor == null) {
            return -1;
        }
        return this.executor.capacity();
    }

    public int getSize() {
        if (this.executor == null) {
            return -1;
        }
        return this.executor.size();
    }

    public void enqueue(final MessageExchangeImpl me) throws InterruptedException, MessagingException {
        this.executor.execute(new Runnable(){

            public void run() {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this + " dequeued exchange: " + me));
                    }
                    SedaQueue.this.flow.doRouting(me);
                }
                catch (Throwable e) {
                    log.error((Object)(this + " got error processing " + me), e);
                }
            }
        });
    }

    public void start() throws JBIException {
        this.executor = this.flow.getExecutorFactory().createExecutor("flow.seda." + this.getName());
        super.start();
    }

    public void stop() throws JBIException {
        super.stop();
        this.executor.shutdown();
    }

    public void shutDown() throws JBIException {
        this.stop();
        super.shutDown();
    }

    public String toString() {
        return "SedaQueue{" + this.name + "}";
    }

    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "capacity", "The capacity of the SedaQueue");
        helper.addAttribute(this.getObjectToManage(), "size", "The size (depth) of the SedaQueue");
        return AttributeInfoHelper.join(super.getAttributeInfos(), helper.getAttributeInfos());
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }
}

