/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.resolver;

import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.servicemix.jbi.resolver.EndpointChooser;
import org.apache.servicemix.jbi.resolver.EndpointFilter;
import org.apache.servicemix.jbi.resolver.EndpointResolver;
import org.apache.servicemix.jbi.resolver.FirstChoicePolicy;

public abstract class EndpointResolverSupport
implements EndpointResolver {
    private EndpointChooser chooser;
    private boolean failIfUnavailable = true;

    public ServiceEndpoint resolveEndpoint(ComponentContext context, MessageExchange exchange, EndpointFilter filter) throws JBIException {
        ServiceEndpoint[] endpoints = this.resolveAvailableEndpoints(context, exchange);
        if (endpoints == null) {
            return null;
        }
        if (endpoints.length > 0) {
            endpoints = this.filterEndpoints(endpoints, exchange, filter);
        }
        if (endpoints.length == 0) {
            if (this.failIfUnavailable) {
                throw this.createServiceUnavailableException();
            }
            return null;
        }
        if (endpoints.length == 1) {
            return endpoints[0];
        }
        return this.getChooser().chooseEndpoint(endpoints, context, exchange);
    }

    public boolean isFailIfUnavailable() {
        return this.failIfUnavailable;
    }

    public void setFailIfUnavailable(boolean failIfUnavailable) {
        this.failIfUnavailable = failIfUnavailable;
    }

    public EndpointChooser getChooser() {
        if (this.chooser == null) {
            this.chooser = new FirstChoicePolicy();
        }
        return this.chooser;
    }

    public void setChooser(EndpointChooser chooser) {
        this.chooser = chooser;
    }

    protected abstract JBIException createServiceUnavailableException();

    protected ServiceEndpoint[] filterEndpoints(ServiceEndpoint[] endpoints, MessageExchange exchange, EndpointFilter filter) {
        int matches = 0;
        for (int i = 0; i < endpoints.length; ++i) {
            ServiceEndpoint endpoint = endpoints[i];
            if (filter.evaluate(endpoint, exchange)) {
                ++matches;
                continue;
            }
            endpoints[i] = null;
        }
        if (matches == endpoints.length) {
            return endpoints;
        }
        ServiceEndpoint[] answer = new ServiceEndpoint[matches];
        int j = 0;
        for (int i = 0; i < endpoints.length; ++i) {
            ServiceEndpoint endpoint = endpoints[i];
            if (endpoint == null) continue;
            answer[j++] = endpoints[i];
        }
        return answer;
    }
}

